/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class CharacterRange
implements Arbitrary<Character> {
    private final char min;
    private final char max;

    public CharacterRange(char min, char max) {
        this.min = min;
        this.max = max;
    }

    public RandomGenerator<Character> generator(int genSize) {
        return RandomGenerators.chars(this.min, this.max);
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustive() {
        long maxCount = this.max + '\u0001' - this.min;
        return ExhaustiveGenerators.fromIterable(() -> IntStream.range(this.min, this.max + '\u0001').iterator(), maxCount).map(optionalGenerator -> optionalGenerator.map(anInt -> Character.valueOf((char)anInt.intValue())));
    }
}

