/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;

class DecimalGeneratingArbitrary
implements Arbitrary<BigDecimal> {
    private static final int DEFAULT_SCALE = 2;
    BigDecimal min;
    BigDecimal max;
    int scale = 2;
    BigDecimal shrinkingTarget;

    DecimalGeneratingArbitrary(BigDecimal defaultMin, BigDecimal defaultMax) {
        this.min = defaultMin;
        this.max = defaultMax;
        this.shrinkingTarget = null;
    }

    public RandomGenerator<BigDecimal> generator(int genSize) {
        BigDecimal[] partitionPoints = RandomGenerators.calculateDefaultPartitionPoints(genSize, this.min, this.max);
        return this.decimalGenerator(partitionPoints, genSize);
    }

    private RandomGenerator<BigDecimal> decimalGenerator(BigDecimal[] partitionPoints, int genSize) {
        List edgeCases = this.streamEdgeCases().filter(aDecimal -> aDecimal.compareTo(this.min) >= 0 && aDecimal.compareTo(this.max) <= 0).map(value -> new ShrinkableBigDecimal((BigDecimal)value, Range.of(this.min, this.max), this.scale, this.shrinkingTarget((BigDecimal)value))).collect(Collectors.toList());
        return RandomGenerators.bigDecimals(this.min, this.max, this.scale, this.shrinkingTargetCalculator(), partitionPoints).withEdgeCases(genSize, edgeCases);
    }

    private Stream<BigDecimal> streamEdgeCases() {
        BigDecimal smallest = BigDecimal.ONE.movePointLeft(this.scale);
        BigDecimal zeroScaled = BigDecimal.ZERO.movePointLeft(this.scale);
        BigDecimal[] literalEdgeCases = new BigDecimal[]{zeroScaled, zeroScaled, zeroScaled, BigDecimal.ONE, BigDecimal.ONE.negate(), smallest, smallest.negate(), this.min, this.max};
        return this.shrinkingTarget == null ? Arrays.stream(literalEdgeCases) : Stream.concat(Stream.of(this.shrinkingTarget), Arrays.stream(literalEdgeCases));
    }

    private Function<BigDecimal, BigDecimal> shrinkingTargetCalculator() {
        if (this.shrinkingTarget == null) {
            return RandomGenerators.defaultShrinkingTargetCalculator(this.min, this.max);
        }
        return ignore -> this.shrinkingTarget;
    }

    private BigDecimal shrinkingTarget(BigDecimal aDecimal) {
        return this.shrinkingTargetCalculator().apply(aDecimal);
    }
}

