/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;

public class DefaultDoubleArbitrary
extends AbstractArbitraryBase
implements DoubleArbitrary {
    private static final double DEFAULT_MIN = -1.7976931348623157E308;
    private static final double DEFAULT_MAX = Double.MAX_VALUE;
    private final DecimalGeneratingArbitrary generatingArbitrary = new DecimalGeneratingArbitrary(this.toBigDecimal(-1.7976931348623157E308), this.toBigDecimal(Double.MAX_VALUE));

    public RandomGenerator<Double> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigDecimal::doubleValue);
    }

    public DoubleArbitrary greaterOrEqual(double min) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.min = this.toBigDecimal(min);
        return clone;
    }

    public DoubleArbitrary lessOrEqual(double max) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.max = this.toBigDecimal(max);
        return clone;
    }

    public DoubleArbitrary ofScale(int scale) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public DoubleArbitrary shrinkTowards(double target) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigDecimal.valueOf(target);
        return clone;
    }

    private BigDecimal toBigDecimal(double value) {
        return new BigDecimal(Double.toString(value));
    }
}

