/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;

public class DefaultIntegerArbitrary
extends AbstractArbitraryBase
implements IntegerArbitrary {
    private static final int DEFAULT_MIN = Integer.MIN_VALUE;
    private static final int DEFAULT_MAX = Integer.MAX_VALUE;
    private final IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Integer.MAX_VALUE));

    public RandomGenerator<Integer> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::intValueExact);
    }

    public Optional<ExhaustiveGenerator<Integer>> exhaustive() {
        return this.generatingArbitrary.exhaustive().map(generator -> generator.map(BigInteger::intValueExact));
    }

    public IntegerArbitrary greaterOrEqual(int min) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public IntegerArbitrary lessOrEqual(int max) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public Arbitrary<Integer> shrinkTowards(int target) {
        DefaultIntegerArbitrary clone = (DefaultIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }
}

