/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;

public class DefaultShortArbitrary
extends AbstractArbitraryBase
implements ShortArbitrary {
    private static final short DEFAULT_MIN = Short.MIN_VALUE;
    private static final short DEFAULT_MAX = Short.MAX_VALUE;
    private final IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(-32768L), BigInteger.valueOf(32767L));

    public RandomGenerator<Short> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::shortValueExact);
    }

    public Optional<ExhaustiveGenerator<Short>> exhaustive() {
        return this.generatingArbitrary.exhaustive().map(generator -> generator.map(BigInteger::shortValueExact));
    }

    public ShortArbitrary greaterOrEqual(short min) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public ShortArbitrary lessOrEqual(short max) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public Arbitrary<Short> shrinkTowards(short target) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }
}

