/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.GenerationError;
import net.jqwik.engine.properties.arbitraries.IgnoreGenerationErrorArbitrary;
import net.jqwik.engine.properties.arbitraries.OneOfArbitrary;
import org.junit.platform.commons.support.ModifierSupport;

public class DefaultTypeArbitrary<T>
extends OneOfArbitrary<T>
implements TypeArbitrary<T> {
    private final Class<T> targetType;
    private final Set<Executable> creators = new HashSet<Executable>();
    private boolean defaultsSet = false;

    public DefaultTypeArbitrary(Class<T> targetType) {
        super(Collections.emptyList());
        this.targetType = targetType;
    }

    public TypeArbitrary<T> useDefaults() {
        this.usePublicConstructors();
        this.useAllFactoryMethods();
        this.defaultsSet = true;
        return this;
    }

    public TypeArbitrary<T> use(Executable creator) {
        if (this.defaultsSet) {
            this.creators.clear();
            this.arbitraries().clear();
            this.defaultsSet = false;
        }
        if (this.creators.contains(creator)) {
            return this;
        }
        this.checkCreator(creator);
        this.addArbitrary(this.createArbitrary(creator));
        this.creators.add(creator);
        return this;
    }

    public TypeArbitrary<T> useConstructors(Predicate<? super Constructor<?>> filter) {
        if (ModifierSupport.isAbstract(this.targetType)) {
            return this;
        }
        Arrays.stream(this.targetType.getDeclaredConstructors()).filter(this::isNotRecursive).filter(filter).forEach(this::use);
        return this;
    }

    public TypeArbitrary<T> usePublicConstructors() {
        return this.useConstructors(ModifierSupport::isPublic);
    }

    public TypeArbitrary<T> useAllConstructors() {
        return this.useConstructors(ctor -> true);
    }

    public TypeArbitrary<T> useFactoryMethods(Predicate<Method> filter) {
        Arrays.stream(this.targetType.getDeclaredMethods()).filter(ModifierSupport::isStatic).filter(this::hasFittingReturnType).filter(this::isNotRecursive).filter(filter).forEach(this::use);
        return this;
    }

    public TypeArbitrary<T> usePublicFactoryMethods() {
        return this.useFactoryMethods(ModifierSupport::isPublic);
    }

    public TypeArbitrary<T> useAllFactoryMethods() {
        return this.useFactoryMethods(method -> true);
    }

    private void checkCreator(Executable creator) {
        this.checkReturnType(creator);
        if (creator instanceof Method) {
            this.checkMethod((Method)creator);
        }
        if (creator instanceof Constructor) {
            this.checkConstructor((Constructor)creator);
        }
    }

    private void checkReturnType(Executable creator) {
        if (!this.hasFittingReturnType(creator)) {
            throw new JqwikException(String.format("Creator %s should return type %s", creator, this.targetType.getName()));
        }
    }

    private boolean hasFittingReturnType(Executable creator) {
        TypeUsage returnType = TypeUsage.forType((Type)creator.getAnnotatedReturnType().getType());
        return returnType.canBeAssignedTo(TypeUsage.of(this.targetType, (TypeUsage[])new TypeUsage[0]));
    }

    private boolean isNotRecursive(Executable creator) {
        return Arrays.stream(creator.getParameterTypes()).noneMatch(parameterType -> parameterType.equals(this.targetType));
    }

    private void checkMethod(Method method) {
        if (!ModifierSupport.isStatic((Member)method)) {
            throw new JqwikException(String.format("Method %s should be static", method));
        }
    }

    private void checkConstructor(Constructor method) {
    }

    @Override
    public RandomGenerator<T> generator(int genSize) {
        if (this.arbitraries().isEmpty()) {
            String message = String.format("%s has no arbitraries to choose from.", this.toString());
            throw new JqwikException(message);
        }
        return super.generator(genSize);
    }

    @Override
    public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return Optional.empty();
    }

    public String toString() {
        return String.format("TypeArbitrary<%s>", this.targetType.getName());
    }

    private Arbitrary<T> createArbitrary(Executable creator) {
        List parameterArbitraries = Arrays.stream(creator.getAnnotatedParameterTypes()).map(annotatedType -> Arbitraries.defaultFor((TypeUsage)TypeUsage.forType((Type)annotatedType.getType()))).collect(Collectors.toList());
        Function<List, Object> combinator = paramList -> this.combinator(creator).apply(paramList.toArray());
        Arbitrary arbitrary = Combinators.combine(parameterArbitraries).as(combinator);
        return new IgnoreGenerationErrorArbitrary(arbitrary);
    }

    private Function<Object[], T> combinator(Executable creator) {
        if (creator instanceof Method) {
            return this.combinatorForMethod((Method)creator);
        }
        if (creator instanceof Constructor) {
            return this.combinatorForConstructor((Constructor)creator);
        }
        throw new JqwikException(String.format("Creator %s is not supported", creator));
    }

    private Function<Object[], T> combinatorForMethod(Method method) {
        method.setAccessible(true);
        return params -> this.generateNext((Object[])params, p -> method.invoke(null, p));
    }

    private Function<Object[], T> combinatorForConstructor(Constructor constructor) {
        constructor.setAccessible(true);
        return params -> this.generateNext((Object[])params, constructor::newInstance);
    }

    private T generateNext(Object[] params, Combinator combinator) {
        try {
            return (T)combinator.combine(params);
        }
        catch (Throwable throwable) {
            throw new GenerationError(throwable);
        }
    }

    public int countCreators() {
        return this.creators.size();
    }

    @FunctionalInterface
    private static interface Combinator {
        public Object combine(Object[] var1) throws Throwable;
    }
}

