/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class OneOfArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final List<Arbitrary<T>> all = new ArrayList<Arbitrary<T>>();

    public OneOfArbitrary(List<Arbitrary<T>> all) {
        this.all.addAll(all);
    }

    public RandomGenerator<T> generator(int genSize) {
        return RandomGenerators.choose(this.all).flatMap(Function.identity(), genSize);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return ExhaustiveGenerators.choose(this.all).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, Function.identity()));
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.all.replaceAll(a -> {
            if (a instanceof SelfConfiguringArbitrary) {
                return ((SelfConfiguringArbitrary)a).configure(configurator, targetType);
            }
            return configurator.configure(a, targetType);
        });
        return this;
    }

    protected List<Arbitrary<T>> arbitraries() {
        return this.all;
    }

    protected void addArbitrary(Arbitrary<T> arbitrary) {
        this.all.add(arbitrary);
    }
}

