/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.MathSupport;

class SetExhaustiveGenerator<T>
implements ExhaustiveGenerator<Set<T>> {
    private final Arbitrary<T> elementArbitrary;
    private final long maxCount;
    private final int minSize;
    private final int maxSize;

    static Optional<Long> calculateMaxCount(Arbitrary<?> elementArbitrary, int minSize, int maxSize) {
        Optional exhaustiveElement = elementArbitrary.exhaustive();
        if (!exhaustiveElement.isPresent()) {
            return Optional.empty();
        }
        long elementMaxCount = ((ExhaustiveGenerator)exhaustiveElement.get()).maxCount();
        long sum = 0L;
        for (int k = minSize; k <= maxSize; ++k) {
            if (k == 0) {
                ++sum;
                continue;
            }
            if (elementMaxCount < (long)k) continue;
            if (elementMaxCount > 70L) {
                return Optional.empty();
            }
            long choices = 0L;
            try {
                choices = MathSupport.binomial(Math.toIntExact(elementMaxCount), k);
            }
            catch (ArithmeticException ae) {
                return Optional.empty();
            }
            if (choices > ExhaustiveGenerators.MAXIMUM_ACCEPTED_MAX_COUNT || choices < 0L) {
                return Optional.empty();
            }
            sum += choices;
        }
        return Optional.of(sum);
    }

    SetExhaustiveGenerator(Arbitrary<T> elementArbitrary, long maxCount, int minSize, int maxSize) {
        this.elementArbitrary = elementArbitrary;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.maxCount = maxCount;
    }

    public Iterator<Set<T>> iterator() {
        return Combinatorics.setCombinations((Iterable)this.elementArbitrary.exhaustive().get(), this.minSize, this.maxSize);
    }

    public long maxCount() {
        return this.maxCount;
    }
}

