/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.shrinking.BigIntegerShrinkingCandidates;
import net.jqwik.engine.properties.shrinking.ShrinkingCandidates;

public class BigDecimalShrinkingCandidates
implements ShrinkingCandidates<BigDecimal> {
    private final Range<BigDecimal> range;
    private final BigIntegerShrinkingCandidates integralShrinkCandidates;

    public BigDecimalShrinkingCandidates(Range<BigDecimal> range, BigDecimal target) {
        this.range = range;
        this.integralShrinkCandidates = new BigIntegerShrinkingCandidates(target.toBigInteger());
    }

    @Override
    public Set<BigDecimal> candidatesFor(BigDecimal value) {
        HashSet<BigDecimal> candidates = new HashSet<BigDecimal>();
        if (this.hasDecimals(value)) {
            candidates.addAll(this.shrinkDecimals(value));
        }
        candidates.addAll(this.shrinkIntegral(value));
        return candidates;
    }

    private Set<BigDecimal> shrinkDecimals(BigDecimal value) {
        HashSet<BigDecimal> shrunkDecimals = new HashSet<BigDecimal>();
        this.range.ifIncluded(this.roundOneDigitDown(value), shrunkDecimals::add);
        this.range.ifIncluded(this.roundOneDigitUp(value), shrunkDecimals::add);
        return shrunkDecimals;
    }

    private BigDecimal roundOneDigitUp(BigDecimal value) {
        return value.setScale(value.scale() - 1, 0);
    }

    private BigDecimal roundOneDigitDown(BigDecimal value) {
        return value.setScale(value.scale() - 1, 1);
    }

    private Set<BigDecimal> shrinkIntegral(BigDecimal value) {
        return this.integralShrinkCandidates.candidatesFor(value.toBigInteger()).stream().map(BigDecimal::new).filter(this.range::includes).collect(Collectors.toSet());
    }

    private boolean hasDecimals(BigDecimal value) {
        if (value.scale() <= 0) {
            return false;
        }
        return value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }
}

