/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.api.stateful.Invariant;
import net.jqwik.engine.properties.stateful.ActionGenerator;
import net.jqwik.engine.properties.stateful.InvariantFailedError;
import net.jqwik.engine.support.JqwikStringSupport;
import org.opentest4j.AssertionFailedError;

class SequentialActionSequence<M>
implements ActionSequence<M> {
    protected ActionGenerator<M> actionGenerator;
    protected int intendedSize;
    protected final List<Action<M>> sequence = new ArrayList<Action<M>>();
    private final List<Invariant<M>> invariants = new ArrayList<Invariant<M>>();
    protected ActionSequence.RunState runState = ActionSequence.RunState.NOT_RUN;
    private M currentModel = null;

    SequentialActionSequence(ActionGenerator<M> actionGenerator, int intendedSize) {
        if (intendedSize < 1) {
            throw new IllegalArgumentException("The intended size of an ActionSequence must not be 0");
        }
        this.actionGenerator = actionGenerator;
        this.intendedSize = intendedSize;
    }

    public synchronized List<Action<M>> runActions() {
        return this.sequence;
    }

    public synchronized M run(M model) {
        if (this.runState != ActionSequence.RunState.NOT_RUN) {
            return this.currentModel;
        }
        this.runState = ActionSequence.RunState.RUNNING;
        this.currentModel = model;
        for (int i = 0; i < this.intendedSize; ++i) {
            Action<M> action;
            try {
                action = this.actionGenerator.next(this.currentModel);
            }
            catch (NoSuchElementException nsee) {
                break;
            }
            this.sequence.add(action);
            try {
                this.currentModel = action.run(this.currentModel);
                this.checkInvariants();
                continue;
            }
            catch (InvariantFailedError ife) {
                this.runState = ActionSequence.RunState.FAILED;
                throw ife;
            }
            catch (Throwable t) {
                this.runState = ActionSequence.RunState.FAILED;
                AssertionFailedError assertionFailedError = new AssertionFailedError(this.createErrorMessage("Run", t.getMessage()), t);
                assertionFailedError.setStackTrace(t.getStackTrace());
                throw assertionFailedError;
            }
        }
        if (this.sequence.isEmpty()) {
            throw new JqwikException("Could not generated a single action. At least 1 is required.");
        }
        this.runState = ActionSequence.RunState.SUCCEEDED;
        return this.currentModel;
    }

    private void checkInvariants() {
        try {
            for (Invariant<M> invariant : this.invariants) {
                invariant.check(this.currentModel);
            }
        }
        catch (Throwable t) {
            throw new InvariantFailedError(this.createErrorMessage("Invariant", t.getMessage()), t);
        }
    }

    private String createErrorMessage(String name, String causeMessage) {
        String actionsString = this.sequence.stream().map(aTry -> "    " + aTry.toString()).collect(Collectors.joining(System.lineSeparator()));
        return String.format("%s failed after following actions:%n%s%n  final currentModel: %s%n%s", name, actionsString, JqwikStringSupport.displayString(this.currentModel), causeMessage);
    }

    public synchronized ActionSequence<M> withInvariant(Invariant<M> invariant) {
        this.invariants.add(invariant);
        return this;
    }

    public ActionSequence.RunState runState() {
        return this.runState;
    }

    public synchronized M finalModel() {
        return this.currentModel;
    }

    public String toString() {
        if (this.runState == ActionSequence.RunState.NOT_RUN) {
            return String.format("ActionSequence[%s]: %s actions intended", this.runState.name(), this.intendedSize);
        }
        String actionsString = JqwikStringSupport.displayString(this.sequence);
        return String.format("ActionSequence[%s]: %s", this.runState.name(), actionsString);
    }
}

