/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.TypeResolution;
import org.junit.platform.commons.support.AnnotationSupport;

public class MethodParameter {
    private final Parameter rawParameter;
    private final TypeResolution resolution;

    public Parameter getRawParameter() {
        return this.rawParameter;
    }

    public MethodParameter(Parameter rawParameter, TypeResolution resolution) {
        this.rawParameter = rawParameter;
        this.resolution = resolution;
    }

    public boolean isAnnotatedParameterized() {
        return this.resolution.annotatedType() instanceof AnnotatedParameterizedType;
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)this.rawParameter, annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)this.findAnnotation(annotationClass).orElse(null));
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)this.rawParameter, annotationClass);
    }

    public Type getType() {
        return this.resolution.type();
    }

    public String toString() {
        return this.rawParameter.toString();
    }

    public List<Annotation> findAllAnnotations() {
        return JqwikAnnotationSupport.findAllAnnotations(this.rawParameter);
    }

    public AnnotatedParameterizedType getAnnotatedType() {
        if (this.isAnnotatedParameterized()) {
            return (AnnotatedParameterizedType)this.resolution.annotatedType();
        }
        return null;
    }
}

