package net.jqwik.engine.support;

import java.lang.annotation.*;
import java.lang.reflect.*;
import java.util.*;

import org.apiguardian.api.*;

public class JqwikAnnotationSupport {

	/**
	 * Find all annotations in an element, even if they are repeatable or only present through meta-annotations
	 *
	 * @param element the element to check for present annotations
	 * @return a list of all found annotations
	 */
	public static List<Annotation> findAllAnnotations(AnnotatedElement element) {

		List<Annotation> annotations = new ArrayList<>();
		List<Annotation> presentAnnotations = Arrays.asList(getDeclaredAnnotations(element));
		annotations.addAll(presentAnnotations);
		presentAnnotations.forEach(annotation -> appendMetaAnnotations(annotation, annotations));
		return annotations;
	}

	private static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
		if (element instanceof AnnotatedArrayType) {
			return ((AnnotatedArrayType) element).getAnnotatedGenericComponentType().getAnnotations();
		}
		return element.getAnnotations();
	}

	private static void appendMetaAnnotations(Annotation annotation, List<Annotation> collector) {
		Annotation[] metaAnnotationCandidates = annotation.annotationType().getDeclaredAnnotations();
		Arrays.stream(metaAnnotationCandidates) //
				.filter(candidate -> !isInJavaLangAnnotationPackage(candidate.annotationType())) //
				.filter(candidate -> !isApiAnnotation(candidate.annotationType())) //
				.filter(candidate -> !collector.contains(candidate)) //
				.forEach(metaAnnotation -> {
					collector.add(metaAnnotation);
					appendMetaAnnotations(metaAnnotation, collector);
				});
	}

	private static boolean isApiAnnotation(Class<? extends Annotation> annotationType) {
		return annotationType == API.class;
	}

	private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
		return (annotationType != null && annotationType.getName().startsWith("java.lang.annotation"));
	}

}
