/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.engine.JqwikConfiguration;
import net.jqwik.engine.JqwikProperties;
import net.jqwik.engine.PropertyDefaultValues;
import net.jqwik.engine.TestEngineConfiguration;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.recording.TestRunData;
import net.jqwik.engine.recording.TestRunDatabase;
import net.jqwik.engine.recording.TestRunRecorder;
import org.junit.platform.engine.UniqueId;

public class DefaultJqwikConfiguration
implements JqwikConfiguration {
    private final JqwikProperties properties;
    private TestEngineConfiguration testEngineConfiguration = null;

    DefaultJqwikConfiguration() {
        this(new JqwikProperties());
    }

    private DefaultJqwikConfiguration(JqwikProperties properties) {
        this.properties = properties;
    }

    @Override
    public PropertyDefaultValues propertyDefaultValues() {
        return PropertyDefaultValues.with(this.properties.defaultTries(), this.properties.defaultMaxDiscardRatio(), this.properties.defaultAfterFailure(), this.properties.defaultGeneration());
    }

    @Override
    public TestEngineConfiguration testEngineConfiguration() {
        if (null == this.testEngineConfiguration) {
            this.testEngineConfiguration = this.createTestEngineConfiguration();
        }
        return this.testEngineConfiguration;
    }

    @Override
    public boolean useJunitPlatformReporter() {
        return this.properties.useJunitPlatformReporter();
    }

    @Override
    public boolean reportOnlyFailures() {
        return this.properties.reportOnlyFailures();
    }

    private TestEngineConfiguration createTestEngineConfiguration() {
        final TestRunDatabase database = new TestRunDatabase(Paths.get(this.properties.databasePath(), new String[0]));
        final TestRunData previousRun = database.previousRun();
        return new TestEngineConfiguration(){

            @Override
            public TestRunRecorder recorder() {
                return database.recorder();
            }

            @Override
            public TestRunData previousRun() {
                return database.previousRun();
            }

            @Override
            public Set<UniqueId> previousFailures() {
                if (!DefaultJqwikConfiguration.this.properties.runFailuresFirst()) {
                    return Collections.emptySet();
                }
                return previousRun.allNonSuccessfulTests().map(TestRun::getUniqueId).collect(Collectors.toSet());
            }
        };
    }
}

