/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.JqwikException;

public class JqwikProperties {
    private static final String[] SUPPORTED_PROPERTIES = new String[]{"database", "runFailuresFirst", "defaultTries", "defaultMaxDiscardRatio", "useJunitPlatformReporter", "defaultAfterFailure", "reportOnlyFailures", "defaultGeneration"};
    private static final String PROPERTIES_FILE_NAME = "jqwik.properties";
    private static final Logger LOG = Logger.getLogger(JqwikProperties.class.getName());
    private static final String DEFAULT_DATABASE_PATH = ".jqwik-database";
    private static final String DEFAULT_RERUN_FAILURES_FIRST = "false";
    private static final String DEFAULT_TRIES = "1000";
    private static final String DEFAULT_MAX_DISCARD_RATIO = "5";
    private static final String DEFAULT_AFTER_FAILURE = AfterFailureMode.PREVIOUS_SEED.name();
    private static final String DEFAULT_REPORT_ONLY_FAILURES = "false";
    private static final String DEFAULT_GENERATION = GenerationMode.AUTO.name();
    private static final String DEFAULT_USE_JUNIT_PLATFORM_REPORTER = "false";
    private String databasePath;
    private boolean runFailuresFirst;
    private int defaultTries;
    private int defaultMaxDiscardRatio;
    private boolean useJunitPlatformReporter;
    private AfterFailureMode defaultAfterFailure;
    private boolean reportOnlyFailures;
    private GenerationMode defaultGeneration;

    public String databasePath() {
        return this.databasePath;
    }

    public boolean runFailuresFirst() {
        return this.runFailuresFirst;
    }

    public int defaultTries() {
        return this.defaultTries;
    }

    public int defaultMaxDiscardRatio() {
        return this.defaultMaxDiscardRatio;
    }

    public boolean useJunitPlatformReporter() {
        return this.useJunitPlatformReporter;
    }

    public AfterFailureMode defaultAfterFailure() {
        return this.defaultAfterFailure;
    }

    public boolean reportOnlyFailures() {
        return this.reportOnlyFailures;
    }

    public GenerationMode defaultGeneration() {
        return this.defaultGeneration;
    }

    JqwikProperties() {
        this(PROPERTIES_FILE_NAME);
    }

    JqwikProperties(String fileName) {
        this.loadProperties(fileName);
    }

    private void loadProperties(String propertiesFileName) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
        if (inputStream == null) {
            LOG.info(String.format("No Jqwik properties file [%s] found.", propertiesFileName));
            inputStream = new ByteArrayInputStream("".getBytes());
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.warnOnUnsupportedProperties(properties);
            this.databasePath = properties.getProperty("database", DEFAULT_DATABASE_PATH);
            this.runFailuresFirst = Boolean.parseBoolean(properties.getProperty("runFailuresFirst", "false"));
            this.defaultTries = Integer.parseInt(properties.getProperty("defaultTries", DEFAULT_TRIES));
            this.defaultMaxDiscardRatio = Integer.parseInt(properties.getProperty("defaultMaxDiscardRatio", DEFAULT_MAX_DISCARD_RATIO));
            this.useJunitPlatformReporter = Boolean.parseBoolean(properties.getProperty("useJunitPlatformReporter", "false"));
            this.defaultAfterFailure = AfterFailureMode.valueOf((String)properties.getProperty("defaultAfterFailure", DEFAULT_AFTER_FAILURE));
            this.reportOnlyFailures = Boolean.parseBoolean(properties.getProperty("reportOnlyFailures", "false"));
            this.defaultGeneration = GenerationMode.valueOf((String)properties.getProperty("defaultGeneration", DEFAULT_GENERATION));
        }
        catch (Throwable throwable) {
            String message = String.format("Error while reading properties file [%s]", propertiesFileName);
            throw new JqwikException(message, throwable);
        }
    }

    private void warnOnUnsupportedProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            if (Arrays.asList(SUPPORTED_PROPERTIES).contains(propertyName)) continue;
            String message = String.format("Property [%s] is not supported in '%s' file", propertyName, PROPERTIES_FILE_NAME);
            LOG.log(Level.WARNING, message);
        }
    }
}

