/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.util.function.Supplier;
import net.jqwik.engine.DefaultJqwikConfiguration;
import net.jqwik.engine.JqwikConfiguration;
import net.jqwik.engine.descriptor.JqwikEngineDescriptor;
import net.jqwik.engine.discovery.JqwikDiscoverer;
import net.jqwik.engine.execution.JqwikExecutor;
import net.jqwik.engine.execution.lifecycle.JqwikLifecycleRegistrator;
import net.jqwik.engine.execution.lifecycle.LifecycleRegistry;
import net.jqwik.engine.recording.TestRunRecorder;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;

public class JqwikTestEngine
implements TestEngine {
    public static final String ENGINE_ID = "jqwik";
    private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry();
    private JqwikConfiguration configuration;
    private Throwable startupThrowable = null;

    public JqwikTestEngine() {
        this(DefaultJqwikConfiguration::new);
    }

    JqwikTestEngine(Supplier<JqwikConfiguration> configurationSupplier) {
        try {
            this.configuration = configurationSupplier.get();
        }
        catch (Throwable engineStartupThrowable) {
            this.startupThrowable = engineStartupThrowable;
        }
    }

    public String getId() {
        return ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest request, UniqueId uniqueId) {
        if (this.startupThrowable != null) {
            JqwikExceptionSupport.throwAsUncheckedException(this.startupThrowable);
        }
        JqwikEngineDescriptor engineDescriptor = new JqwikEngineDescriptor(uniqueId);
        new JqwikDiscoverer(this.configuration.testEngineConfiguration().previousRun(), this.configuration.propertyDefaultValues()).discover(request, (TestDescriptor)engineDescriptor);
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        TestDescriptor root = request.getRootTestDescriptor();
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        this.registerLifecycleHooks(root, request.getConfigurationParameters());
        this.executeTests(root, engineExecutionListener);
    }

    private void executeTests(TestDescriptor root, EngineExecutionListener listener) {
        try (TestRunRecorder recorder = this.configuration.testEngineConfiguration().recorder();){
            new JqwikExecutor(this.lifecycleRegistry, recorder, this.configuration.testEngineConfiguration().previousFailures(), this.configuration.useJunitPlatformReporter(), this.configuration.reportOnlyFailures()).execute(root, listener);
        }
    }

    private void registerLifecycleHooks(TestDescriptor rootDescriptor, ConfigurationParameters configurationParameters) {
        new JqwikLifecycleRegistrator(this.lifecycleRegistry, configurationParameters).registerLifecycleHooks(rootDescriptor);
    }
}

