/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Reporting;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.CheckedFunction;
import net.jqwik.engine.properties.DataBasedShrinkablesGenerator;
import net.jqwik.engine.properties.ExhaustiveShrinkablesGenerator;
import net.jqwik.engine.properties.GenericProperty;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.properties.RandomizedShrinkablesGenerator;
import net.jqwik.engine.properties.SampleOnlyShrinkablesGenerator;
import net.jqwik.engine.properties.ShrinkablesGenerator;
import net.jqwik.engine.properties.SourceOfRandomness;
import net.jqwik.engine.support.MethodParameter;
import org.junit.platform.engine.reporting.ReportEntry;

public class CheckedProperty {
    public final String propertyName;
    public final CheckedFunction checkedFunction;
    public final List<MethodParameter> forAllParameters;
    public final PropertyConfiguration configuration;
    private final ArbitraryResolver arbitraryResolver;
    private final Optional<Iterable<? extends Tuple>> optionalData;
    private Optional<ExhaustiveShrinkablesGenerator> optionalExhaustive;

    public CheckedProperty(String propertyName, CheckedFunction checkedFunction, List<MethodParameter> forAllParameters, ArbitraryResolver arbitraryResolver, Optional<Iterable<? extends Tuple>> optionalData, PropertyConfiguration configuration) {
        this.propertyName = propertyName;
        this.checkedFunction = checkedFunction;
        this.forAllParameters = forAllParameters;
        this.arbitraryResolver = arbitraryResolver;
        this.optionalData = optionalData;
        this.configuration = configuration;
    }

    public PropertyCheckResult check(Consumer<ReportEntry> publisher, Reporting[] reporting, boolean reportOnlyFailures) {
        PropertyConfiguration effectiveConfiguration = this.configurationWithEffectiveSeed();
        try {
            return this.createGenericProperty(effectiveConfiguration).check(publisher, reporting, reportOnlyFailures);
        }
        catch (CannotFindArbitraryException cannotFindArbitraryException) {
            return PropertyCheckResult.erroneous(effectiveConfiguration.getStereotype(), this.propertyName, 0, 0, effectiveConfiguration.getSeed(), this.configuration.getGenerationMode(), Collections.emptyList(), null, cannotFindArbitraryException);
        }
    }

    private PropertyConfiguration configurationWithEffectiveSeed() {
        if (!this.configuration.getSeed().equals("")) {
            return this.configuration.withSeed(this.configuration.getSeed());
        }
        if (this.configuration.getPreviousSeed() != null && this.configuration.getAfterFailureMode() != AfterFailureMode.RANDOM_SEED) {
            return this.configuration.withSeed(this.configuration.getPreviousSeed());
        }
        return this.configuration.withSeed(SourceOfRandomness.createRandomSeed());
    }

    private GenericProperty createGenericProperty(PropertyConfiguration configuration) {
        if (configuration.getGenerationMode() == GenerationMode.RANDOMIZED) {
            this.ensureValidRandomizedMode();
        } else if (configuration.getGenerationMode() == GenerationMode.DATA_DRIVEN) {
            this.ensureValidDataDrivenMode();
        } else if (configuration.getGenerationMode() == GenerationMode.EXHAUSTIVE) {
            this.ensureValidExhaustiveMode();
            configuration = configuration.withTries(Math.toIntExact(this.getOptionalExhaustive().get().maxCount()));
        } else if (configuration.getGenerationMode() == GenerationMode.AUTO) {
            configuration = this.chooseGenerationMode(configuration);
        }
        ShrinkablesGenerator shrinkablesGenerator = this.createShrinkablesGenerator(configuration);
        return new GenericProperty(this.propertyName, configuration, shrinkablesGenerator, this.checkedFunction);
    }

    private ShrinkablesGenerator createShrinkablesGenerator(PropertyConfiguration configuration) {
        List<Object> falsifiedSample = configuration.getFalsifiedSample();
        if (falsifiedSample != null && !falsifiedSample.isEmpty()) {
            if (configuration.getAfterFailureMode() == AfterFailureMode.SAMPLE_ONLY) {
                return this.createSampleOnlyShrinkableGenerator(configuration);
            }
            if (configuration.getAfterFailureMode() == AfterFailureMode.SAMPLE_FIRST) {
                return this.createSampleOnlyShrinkableGenerator(configuration).andThen(() -> this.createDefaultShrinkablesGenerator(configuration));
            }
        }
        return this.createDefaultShrinkablesGenerator(configuration);
    }

    private ShrinkablesGenerator createDefaultShrinkablesGenerator(PropertyConfiguration configuration) {
        switch (configuration.getGenerationMode()) {
            case EXHAUSTIVE: {
                return this.getOptionalExhaustive().get();
            }
            case DATA_DRIVEN: {
                return this.createDataBasedShrinkablesGenerator(configuration);
            }
        }
        return this.createRandomizedShrinkablesGenerator(configuration);
    }

    private void ensureValidRandomizedMode() {
        if (this.optionalData.isPresent()) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = RANDOMIZED)");
        }
    }

    private void ensureValidExhaustiveMode() {
        if (this.optionalData.isPresent()) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = EXHAUSTIVE)");
        }
        if (!this.getOptionalExhaustive().isPresent()) {
            throw new JqwikException("EXHAUSTIVE generation is not possible. Maybe too many potential examples?");
        }
    }

    private void ensureValidDataDrivenMode() {
        if (!this.optionalData.isPresent()) {
            throw new JqwikException("With @Property(generation = DATA_DRIVEN) there must be a @FromData annotation");
        }
    }

    private PropertyConfiguration chooseGenerationMode(PropertyConfiguration configuration) {
        configuration = this.optionalData.isPresent() ? configuration.withGenerationMode(GenerationMode.DATA_DRIVEN) : (this.getOptionalExhaustive().isPresent() && this.getOptionalExhaustive().get().maxCount() <= (long)configuration.getTries() ? configuration.withGenerationMode(GenerationMode.EXHAUSTIVE) : configuration.withGenerationMode(GenerationMode.RANDOMIZED));
        return configuration;
    }

    private Optional<ExhaustiveShrinkablesGenerator> createOptionalExhaustiveShrinkablesGenerator(long maxNumberOfSamples) {
        if (this.forAllParameters.isEmpty()) {
            return Optional.empty();
        }
        try {
            ExhaustiveShrinkablesGenerator exhaustiveShrinkablesGenerator = ExhaustiveShrinkablesGenerator.forParameters(this.forAllParameters, this.arbitraryResolver, maxNumberOfSamples);
            return Optional.of(exhaustiveShrinkablesGenerator);
        }
        catch (TooManyFilterMissesException tmfme) {
            throw tmfme;
        }
        catch (JqwikException ex) {
            return Optional.empty();
        }
    }

    private ShrinkablesGenerator createDataBasedShrinkablesGenerator(PropertyConfiguration configuration) {
        if (configuration.getGenerationMode() != GenerationMode.DATA_DRIVEN) {
            throw new JqwikException("You cannot have both a @FromData annotation and @Property(generation = RANDOMIZED)");
        }
        return new DataBasedShrinkablesGenerator(this.forAllParameters, this.optionalData.get());
    }

    private ShrinkablesGenerator createRandomizedShrinkablesGenerator(PropertyConfiguration configuration) {
        Random random = SourceOfRandomness.create(configuration.getSeed());
        return RandomizedShrinkablesGenerator.forParameters(this.forAllParameters, this.arbitraryResolver, random, configuration.getTries());
    }

    private ShrinkablesGenerator createSampleOnlyShrinkableGenerator(PropertyConfiguration configuration) {
        return new SampleOnlyShrinkablesGenerator(this.forAllParameters, configuration.getFalsifiedSample());
    }

    private Optional<ExhaustiveShrinkablesGenerator> getOptionalExhaustive() {
        if (this.optionalExhaustive == null) {
            long maxNumberOfSamples = this.configuration.getGenerationMode() == GenerationMode.EXHAUSTIVE ? Integer.MAX_VALUE : (long)this.configuration.getTries();
            this.optionalExhaustive = this.createOptionalExhaustiveShrinkablesGenerator(maxNumberOfSamples);
        }
        return this.optionalExhaustive;
    }
}

