/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.execution.ContainerClassLifecycleContext;
import net.jqwik.engine.execution.ExecutionTaskCreator;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.execution.pipeline.Pipeline;
import org.junit.platform.engine.TestDescriptor;

class ContainerTaskCreator {
    ContainerTaskCreator() {
    }

    ExecutionTask createTask(TestDescriptor containerDescriptor, ExecutionTaskCreator childTaskCreator, Pipeline pipeline, LifecycleSupplier lifecycleSupplier) {
        ExecutionTask[] childrenTasks;
        ContainerLifecycleContext containerLifecycleContext = this.createLifecycleContext(containerDescriptor);
        SkipExecutionHook skipExecutionHook = lifecycleSupplier.skipExecutionHook(containerDescriptor);
        SkipExecutionHook.SkipResult skipResult = skipExecutionHook.shouldBeSkipped((LifecycleContext)containerLifecycleContext);
        if (skipResult.isSkipped()) {
            return ExecutionTask.from(listener -> listener.executionSkipped(containerDescriptor, skipResult.reason().orElse(null)), containerDescriptor.getUniqueId(), "skip " + containerDescriptor.getDisplayName());
        }
        ExecutionTask prepareContainerTask = ExecutionTask.from(listener -> listener.executionStarted(containerDescriptor), containerDescriptor.getUniqueId(), "prepare " + containerDescriptor.getDisplayName());
        for (ExecutionTask childTask : childrenTasks = this.createChildren(containerDescriptor.getChildren(), childTaskCreator, pipeline)) {
            pipeline.submit(childTask, prepareContainerTask);
        }
        ExecutionTask finishContainerTask = ExecutionTask.from(listener -> {
            PropertyExecutionResult result = PropertyExecutionResult.successful();
            listener.executionFinished(containerDescriptor, result);
        }, containerDescriptor.getUniqueId(), "finish " + containerDescriptor.getDisplayName());
        if (childrenTasks.length == 0) {
            pipeline.submit(finishContainerTask, prepareContainerTask);
        } else {
            pipeline.submit(finishContainerTask, childrenTasks);
        }
        return prepareContainerTask;
    }

    private ContainerLifecycleContext createLifecycleContext(final TestDescriptor containerDescriptor) {
        if (containerDescriptor instanceof ContainerClassDescriptor) {
            ContainerClassDescriptor classDescriptor = (ContainerClassDescriptor)containerDescriptor;
            return new ContainerClassLifecycleContext(classDescriptor);
        }
        return new ContainerLifecycleContext(){

            public String label() {
                return containerDescriptor.getDisplayName();
            }

            public Optional<AnnotatedElement> annotatedElement() {
                return Optional.empty();
            }
        };
    }

    private ExecutionTask[] createChildren(Set<? extends TestDescriptor> children, ExecutionTaskCreator childTaskCreator, Pipeline pipeline) {
        ExecutionTask[] childrenTasks = new ExecutionTask[]{};
        return children.stream().map(child -> childTaskCreator.createTask((TestDescriptor)child, pipeline)).collect(Collectors.toList()).toArray(childrenTasks);
    }
}

