/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Collections;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.PropertyMethodExecutor;
import net.jqwik.engine.execution.PropertyMethodLifecycleContext;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.support.JqwikReflectionSupport;

class PropertyTaskCreator {
    PropertyTaskCreator() {
    }

    ExecutionTask createTask(PropertyMethodDescriptor methodDescriptor, LifecycleSupplier lifecycleSupplier, boolean reportOnlyFailures) {
        return ExecutionTask.from(listener -> {
            PropertyMethodLifecycleContext propertyLifecycleContext;
            try {
                Object testInstance = this.createTestInstance(methodDescriptor);
                propertyLifecycleContext = new PropertyMethodLifecycleContext(methodDescriptor, testInstance);
                SkipExecutionHook skipExecutionHook = lifecycleSupplier.skipExecutionHook(methodDescriptor);
                SkipExecutionHook.SkipResult skipResult = skipExecutionHook.shouldBeSkipped((LifecycleContext)propertyLifecycleContext);
                if (skipResult.isSkipped()) {
                    listener.executionSkipped(methodDescriptor, skipResult.reason().orElse(null));
                    return;
                }
            }
            catch (Throwable throwable) {
                this.handleExceptionDuringTestInstanceCreation(methodDescriptor, (PropertyExecutionListener)listener, throwable);
                return;
            }
            listener.executionStarted(methodDescriptor);
            PropertyExecutionResult executionResult = this.executeTestMethod(methodDescriptor, propertyLifecycleContext, lifecycleSupplier, (PropertyExecutionListener)listener, reportOnlyFailures);
            listener.executionFinished(methodDescriptor, executionResult);
        }, methodDescriptor.getUniqueId(), "executing " + methodDescriptor.getDisplayName());
    }

    private void handleExceptionDuringTestInstanceCreation(PropertyMethodDescriptor methodDescriptor, PropertyExecutionListener listener, Throwable throwable) {
        listener.executionStarted(methodDescriptor);
        PropertyExecutionResult executionResult = PropertyExecutionResult.failed((Throwable)throwable, (String)methodDescriptor.getConfiguration().getSeed(), Collections.emptyList());
        listener.executionFinished(methodDescriptor, executionResult);
    }

    private Object createTestInstance(PropertyMethodDescriptor methodDescriptor) {
        try {
            return JqwikReflectionSupport.newInstanceWithDefaultConstructor(methodDescriptor.getContainerClass());
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot create instance of class '%s'. Maybe it has no default constructor?", methodDescriptor.getContainerClass());
            throw new JqwikException(message, throwable);
        }
    }

    private PropertyExecutionResult executeTestMethod(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext, LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener, boolean reportOnlyFailures) {
        PropertyMethodExecutor executor = new PropertyMethodExecutor(methodDescriptor, propertyLifecycleContext, reportOnlyFailures);
        return executor.execute(lifecycleSupplier, listener);
    }
}

