/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.opentest4j.MultipleFailuresError;

public class AutoCloseableHook
implements AroundPropertyHook,
LifecycleHook.PropagateToChildren {
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        PropertyExecutionResult testExecutionResult = property.execute();
        List<Throwable> throwableCollector = this.executeCloseMethods(context);
        if (!throwableCollector.isEmpty()) {
            this.handleExceptions(throwableCollector);
        }
        return testExecutionResult;
    }

    public int aroundPropertyProximity() {
        return -100;
    }

    private List<Throwable> executeCloseMethods(PropertyLifecycleContext context) {
        ArrayList<Throwable> throwableCollector = new ArrayList<Throwable>();
        JqwikReflectionSupport.streamInstancesFromInside(context.testInstance()).forEach(innerInstance -> {
            if (innerInstance instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)innerInstance).close();
                }
                catch (Exception t) {
                    throwableCollector.add(t);
                }
            }
        });
        return throwableCollector;
    }

    private void handleExceptions(List<Throwable> throwableCollector) throws Throwable {
        Object throwable = throwableCollector.size() == 1 ? throwableCollector.get(0) : new MultipleFailuresError("Exceptions occurred during close()", throwableCollector);
        throw throwable;
    }
}

