/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.Combinators;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.arbitraries.SizableArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequenceArbitrary;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.RegisteredArbitraryResolver;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.DefaultBigDecimalArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultBigIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultByteArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultDoubleArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultFloatArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultLongArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultShortArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultStringArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultTypeArbitrary;
import net.jqwik.engine.properties.arbitraries.FrequencyOfArbitrary;
import net.jqwik.engine.properties.arbitraries.LazyArbitrary;
import net.jqwik.engine.properties.arbitraries.MapArbitrary;
import net.jqwik.engine.properties.arbitraries.OneOfArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.stateful.DefaultActionSequenceArbitrary;

public class ArbitrariesFacadeImpl
extends Arbitraries.ArbitrariesFacade {
    public <T> RandomGenerator<T> randomChoose(List<T> values) {
        return RandomGenerators.choose(values);
    }

    public <T> Optional<ExhaustiveGenerator<T>> exhaustiveChoose(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(values, maxNumberOfSamples);
    }

    public RandomGenerator<Character> randomChoose(char[] values) {
        return RandomGenerators.choose(values);
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustiveChoose(char[] values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(values, maxNumberOfSamples);
    }

    public <T> Optional<ExhaustiveGenerator<T>> exhaustiveCreate(Supplier<T> supplier, long maxNumberOfSamples) {
        return ExhaustiveGenerators.create(supplier, maxNumberOfSamples);
    }

    public <T extends Enum> RandomGenerator<T> randomChoose(Class<T> enumClass) {
        return RandomGenerators.choose(enumClass);
    }

    public <T extends Enum> Optional<ExhaustiveGenerator<T>> exhaustiveChoose(Class<T> enumClass, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(enumClass, maxNumberOfSamples);
    }

    public <T> Arbitrary<T> oneOf(List<Arbitrary<T>> all) {
        return new OneOfArbitrary<T>(all);
    }

    public <T> RandomGenerator<T> randomFrequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return RandomGenerators.frequency(frequencies);
    }

    public <T> RandomGenerator<T> randomSamples(T[] samples) {
        return RandomGenerators.samples(samples);
    }

    public <T> RandomGenerator<List<T>> randomShuffle(List<T> values) {
        return RandomGenerators.shuffle(values);
    }

    public <T> Optional<ExhaustiveGenerator<List<T>>> exhaustiveShuffle(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.shuffle(values, maxNumberOfSamples);
    }

    public <M> ActionSequenceArbitrary<M> sequences(Arbitrary<Action<M>> actionArbitrary) {
        return new DefaultActionSequenceArbitrary<M>(actionArbitrary);
    }

    public <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        return new FrequencyOfArbitrary<T>(frequencies);
    }

    public IntegerArbitrary integers() {
        return new DefaultIntegerArbitrary();
    }

    public LongArbitrary longs() {
        return new DefaultLongArbitrary();
    }

    public BigIntegerArbitrary bigIntegers() {
        return new DefaultBigIntegerArbitrary();
    }

    public FloatArbitrary floats() {
        return new DefaultFloatArbitrary();
    }

    public BigDecimalArbitrary bigDecimals() {
        return new DefaultBigDecimalArbitrary();
    }

    public DoubleArbitrary doubles() {
        return new DefaultDoubleArbitrary();
    }

    public ByteArbitrary bytes() {
        return new DefaultByteArbitrary();
    }

    public ShortArbitrary shorts() {
        return new DefaultShortArbitrary();
    }

    public StringArbitrary strings() {
        return new DefaultStringArbitrary();
    }

    public CharacterArbitrary chars() {
        return new DefaultCharacterArbitrary();
    }

    public <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> arbitrarySupplier) {
        return new LazyArbitrary<T>(arbitrarySupplier);
    }

    public <T> Arbitrary<T> defaultFor(Class<T> type, Class<?>[] typeParameters) {
        TypeUsage[] genericTypeParameters = (TypeUsage[])Arrays.stream(typeParameters).map(x$0 -> TypeUsage.of((Class)x$0, (TypeUsage[])new TypeUsage[0])).toArray(TypeUsage[]::new);
        return this.defaultFor(TypeUsage.of(type, (TypeUsage[])genericTypeParameters));
    }

    public <T> Arbitrary<T> defaultFor(TypeUsage typeUsage) {
        return Arbitraries.lazy(() -> {
            Set<Arbitrary<?>> arbitraries = ArbitrariesFacadeImpl.allDefaultsFor(typeUsage);
            if (arbitraries.isEmpty()) {
                throw new CannotFindArbitraryException(typeUsage);
            }
            ArrayList arbitrariesList = new ArrayList();
            arbitraries.forEach(arbitrary -> arbitrariesList.add(arbitrary));
            return Arbitraries.oneOf(arbitrariesList);
        });
    }

    public <T> TypeArbitrary<T> forType(Class<T> targetType) {
        return new DefaultTypeArbitrary<T>(targetType).useDefaults();
    }

    public <K, V> SizableArbitrary<Map<K, V>> maps(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return new MapArbitrary<K, V>(keysArbitrary, valuesArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(keysArbitrary, 255));
    }

    public <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return Combinators.combine(keysArbitrary, valuesArbitrary).as(AbstractMap.SimpleEntry::new);
    }

    private static Set<Arbitrary<?>> allDefaultsFor(TypeUsage typeUsage) {
        DomainContext domainContext = DomainContextFacadeImpl.currentContext.get();
        RegisteredArbitraryResolver defaultArbitraryResolver = new RegisteredArbitraryResolver(domainContext.getArbitraryProviders());
        ArbitraryProvider.SubtypeProvider subtypeProvider = ArbitrariesFacadeImpl::allDefaultsFor;
        return defaultArbitraryResolver.resolve(typeUsage, subtypeProvider);
    }
}

