/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.reporting.ReportEntry;

public class CheckResultReportEntry {
    private static final String TRIES_KEY = "tries";
    private static final String CHECKS_KEY = "checks";
    private static final String GENERATION_KEY = "generation-mode";
    private static final String AFTER_FAILURE_KEY = "after-failure";
    private static final String SEED_KEY = "seed";
    private static final String SAMPLE_KEY = "sample";
    private static final String ORIGINAL_REPORT_KEY = "original-sample";

    public static ReportEntry from(String propertyName, PropertyCheckResult checkResult, AfterFailureMode afterFailureMode) {
        return CheckResultReportEntry.buildJqwikReport(propertyName, checkResult, afterFailureMode);
    }

    private static ReportEntry buildJqwikReport(String propertyName, PropertyCheckResult checkResult, AfterFailureMode afterFailureMode) {
        StringBuilder reportLines = new StringBuilder();
        CheckResultReportEntry.appendThrowableMessage(reportLines, checkResult);
        CheckResultReportEntry.appendFixedSizedProperties(reportLines, checkResult, afterFailureMode);
        CheckResultReportEntry.appendSamples(reportLines, checkResult);
        return ReportEntry.from((String)propertyName, (String)reportLines.toString());
    }

    private static void appendSamples(StringBuilder reportLines, PropertyCheckResult checkResult) {
        checkResult.sample().ifPresent(shrunkSample -> {
            if (!shrunkSample.isEmpty()) {
                reportLines.append(String.format("%s%n", CheckResultReportEntry.buildProperty(SAMPLE_KEY, JqwikStringSupport.displayString(shrunkSample))));
            }
        });
        checkResult.originalSample().ifPresent(originalSample -> {
            if (!originalSample.isEmpty()) {
                reportLines.append(String.format("%s%n", CheckResultReportEntry.buildProperty(ORIGINAL_REPORT_KEY, JqwikStringSupport.displayString(originalSample))));
            }
        });
    }

    private static void appendFixedSizedProperties(StringBuilder reportLines, PropertyCheckResult checkResult, AfterFailureMode afterFailureMode) {
        ArrayList<String> propertiesLines = new ArrayList<String>();
        CheckResultReportEntry.appendProperty(propertiesLines, TRIES_KEY, Integer.toString(checkResult.countTries()), "# of calls to property");
        CheckResultReportEntry.appendProperty(propertiesLines, CHECKS_KEY, Integer.toString(checkResult.countChecks()), "# of not rejected calls");
        CheckResultReportEntry.appendProperty(propertiesLines, GENERATION_KEY, checkResult.generation().name(), CheckResultReportEntry.helpGenerationMode(checkResult.generation()));
        if (afterFailureMode != AfterFailureMode.NOT_SET) {
            CheckResultReportEntry.appendProperty(propertiesLines, AFTER_FAILURE_KEY, afterFailureMode.name(), CheckResultReportEntry.helpAfterFailureMode(afterFailureMode));
        }
        CheckResultReportEntry.appendProperty(propertiesLines, SEED_KEY, checkResult.randomSeed(), "random seed to reproduce generated values");
        int halfBorderLength = (propertiesLines.stream().mapToInt(String::length).max().orElse(50) - 37) / 2 + 1;
        String halfBorder = String.join((CharSequence)"", Collections.nCopies(halfBorderLength, "-"));
        reportLines.append(String.format("%n", new Object[0]));
        reportLines.append(CheckResultReportEntry.buildLine("", "|" + halfBorder + "jqwik" + halfBorder));
        propertiesLines.forEach(reportLines::append);
    }

    private static void appendThrowableMessage(StringBuilder reportLines, PropertyCheckResult checkResult) {
        if (checkResult.status() != PropertyCheckResult.Status.SATISFIED) {
            Throwable throwable = (Throwable)checkResult.toExecutionResult().getThrowable().get();
            String assertionClass = throwable.getClass().getName();
            String assertionMessage = throwable.getMessage();
            reportLines.append(String.format("%n%n%s: ", assertionClass));
            reportLines.append(String.format("%s%n", assertionMessage));
        }
    }

    private static String helpAfterFailureMode(AfterFailureMode afterFailureMode) {
        switch (afterFailureMode) {
            case RANDOM_SEED: {
                return "use a new random seed";
            }
            case PREVIOUS_SEED: {
                return "use the previous seed";
            }
            case SAMPLE_ONLY: {
                return "only try the previously failed sample";
            }
            case SAMPLE_FIRST: {
                return "try previously failed sample, then previous seed";
            }
        }
        return "RANDOM_SEED, PREVIOUS_SEED or SAMPLE_FIRST";
    }

    private static String helpGenerationMode(GenerationMode generation) {
        switch (generation) {
            case RANDOMIZED: {
                return "parameters are randomly generated";
            }
            case EXHAUSTIVE: {
                return "parameters are exhaustively generated";
            }
            case DATA_DRIVEN: {
                return "parameters are taken from data provider";
            }
        }
        return "RANDOMIZED, EXHAUSTIVE or DATA_DRIVEN";
    }

    private static void appendProperty(List<String> propertiesLines, String triesKey, String value, String s) {
        propertiesLines.add(CheckResultReportEntry.buildPropertyLine(triesKey, value, s));
    }

    private static String buildPropertyLine(String key, String value, String help) {
        return CheckResultReportEntry.buildLine(CheckResultReportEntry.buildProperty(key, value), String.format("| %s", help));
    }

    private static String buildProperty(String key, String value) {
        return String.format("%s = %s", key, value);
    }

    private static String buildLine(String body, String helpString) {
        return String.format("%-30s%s%n", body, helpString);
    }
}

