/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.ShrinkablesGenerator;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.MethodParameter;

public class ExhaustiveShrinkablesGenerator
implements ShrinkablesGenerator {
    private final Iterator<List<Shrinkable>> combinatorialIterator;
    private final long maxCount;

    public static ExhaustiveShrinkablesGenerator forParameters(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, long maxNumberOfSamples) {
        List<List<ExhaustiveGenerator>> exhaustiveGenerators = parameters.stream().map(parameter -> ExhaustiveShrinkablesGenerator.resolveParameter(arbitraryResolver, parameter, maxNumberOfSamples)).collect(Collectors.toList());
        return new ExhaustiveShrinkablesGenerator(exhaustiveGenerators);
    }

    private static List<ExhaustiveGenerator> resolveParameter(ArbitraryResolver arbitraryResolver, MethodParameter parameter, long maxNumberOfSamples) {
        Set<Arbitrary<?>> arbitraries = arbitraryResolver.forParameter(parameter);
        if (arbitraries.isEmpty()) {
            throw new CannotFindArbitraryException(TypeUsageImpl.forParameter(parameter), parameter.getAnnotation(ForAll.class));
        }
        ArrayList<ExhaustiveGenerator> exhaustiveGenerators = new ArrayList<ExhaustiveGenerator>();
        for (Arbitrary<?> arbitrary : arbitraries) {
            Optional optionalGenerator = arbitrary.exhaustive(maxNumberOfSamples);
            if (!optionalGenerator.isPresent()) {
                String message = String.format("Arbitrary %s does not provide exhaustive generator", arbitrary);
                throw new JqwikException(message);
            }
            exhaustiveGenerators.add((ExhaustiveGenerator)optionalGenerator.get());
        }
        return exhaustiveGenerators;
    }

    private ExhaustiveShrinkablesGenerator(List<List<ExhaustiveGenerator>> generators) {
        this.maxCount = generators.stream().mapToLong(set -> set.stream().mapToLong(ExhaustiveGenerator::maxCount).sum()).reduce((product, count) -> product * count).orElse(1L);
        this.combinatorialIterator = this.combine(generators);
    }

    private Iterator<List<Shrinkable>> combine(List<List<ExhaustiveGenerator>> generators) {
        final List iterables = generators.stream().map(this::concat).collect(Collectors.toList());
        return new Iterator<List<Shrinkable>>(){
            Iterator<List<Object>> iterator;
            {
                this.iterator = Combinatorics.combine(iterables);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public List<Shrinkable> next() {
                ArrayList<Shrinkable> values = new ArrayList<Shrinkable>();
                for (Object o : this.iterator.next()) {
                    values.add(Shrinkable.unshrinkable((Object)o));
                }
                return values;
            }
        };
    }

    private Iterable<Object> concat(List<ExhaustiveGenerator> generatorList) {
        List iterables = generatorList.stream().map(g -> g).collect(Collectors.toList());
        return () -> Combinatorics.concat(iterables);
    }

    @Override
    public boolean hasNext() {
        return this.combinatorialIterator.hasNext();
    }

    @Override
    public List<Shrinkable> next() {
        return this.combinatorialIterator.next();
    }

    public long maxCount() {
        return this.maxCount;
    }
}

