/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Reporting;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.properties.CheckResultReportEntry;
import net.jqwik.engine.properties.CheckedFunction;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.properties.ShrinkablesGenerator;
import net.jqwik.engine.properties.StatisticsCollectorImpl;
import net.jqwik.engine.properties.shrinking.PropertyShrinker;
import net.jqwik.engine.properties.shrinking.PropertyShrinkingResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.reporting.ReportEntry;
import org.opentest4j.TestAbortedException;

public class GenericProperty {
    private final String name;
    private final PropertyConfiguration configuration;
    private final ShrinkablesGenerator shrinkablesGenerator;
    private final CheckedFunction checkedFunction;

    public GenericProperty(String name, PropertyConfiguration configuration, ShrinkablesGenerator shrinkablesGenerator, CheckedFunction checkedFunction) {
        this.name = name;
        this.configuration = configuration;
        this.shrinkablesGenerator = shrinkablesGenerator;
        this.checkedFunction = checkedFunction;
    }

    public PropertyCheckResult check(Consumer<ReportEntry> reporter, Reporting[] reporting, boolean reportOnlyFailures) {
        StatisticsCollectorImpl.clearAll();
        PropertyCheckResult checkResult = this.checkWithoutReporting(reporter, reporting);
        this.reportResult(reporter, checkResult, reportOnlyFailures);
        this.reportStatistics(reporter);
        return checkResult;
    }

    private void reportStatistics(Consumer<ReportEntry> reporter) {
        StatisticsCollectorImpl.report(reporter, this.name);
    }

    private void reportResult(Consumer<ReportEntry> publisher, PropertyCheckResult checkResult, boolean reportOnlyFailures) {
        if (checkResult.status() == PropertyCheckResult.Status.SATISFIED && reportOnlyFailures) {
            return;
        }
        if (checkResult.countTries() > 1 || checkResult.status() != PropertyCheckResult.Status.SATISFIED) {
            publisher.accept(CheckResultReportEntry.from(this.name, checkResult, this.configuration.getAfterFailureMode()));
        }
    }

    private PropertyCheckResult checkWithoutReporting(Consumer<ReportEntry> reporter, Reporting[] reporting) {
        int countTries;
        int maxTries = this.configuration.getTries();
        int countChecks = 0;
        for (countTries = 0; countTries < maxTries && this.shrinkablesGenerator.hasNext(); ++countTries) {
            List shrinkableParams = (List)this.shrinkablesGenerator.next();
            try {
                ++countChecks;
                if (this.testPredicate(shrinkableParams, reporter, reporting)) continue;
                return this.shrinkAndCreateCheckResult(reporter, reporting, countChecks, countTries, shrinkableParams, null);
            }
            catch (AssertionError ae) {
                return this.shrinkAndCreateCheckResult(reporter, reporting, countChecks, countTries, shrinkableParams, (Throwable)((Object)ae));
            }
            catch (TestAbortedException tae) {
                --countChecks;
                continue;
            }
            catch (Exception ex) {
                return this.shrinkAndCreateCheckResult(reporter, reporting, countChecks, countTries, shrinkableParams, ex);
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                return PropertyCheckResult.erroneous(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.extractParams(shrinkableParams), null, throwable);
            }
        }
        if (countChecks == 0 || this.maxDiscardRatioExceeded(countChecks, countTries, this.configuration.getMaxDiscardRatio())) {
            return PropertyCheckResult.exhausted(this.configuration.getStereotype(), this.name, maxTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode());
        }
        return PropertyCheckResult.satisfied(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode());
    }

    private boolean testPredicate(List<Shrinkable> shrinkableParams, Consumer<ReportEntry> reporter, Reporting[] reporting) {
        List<Object> plainParams = this.extractParams(shrinkableParams);
        if (Reporting.GENERATED.containedIn(reporting)) {
            reporter.accept(ReportEntry.from((String)"generated", (String)JqwikStringSupport.displayString(plainParams)));
        }
        return this.checkedFunction.test(plainParams);
    }

    private boolean maxDiscardRatioExceeded(int countChecks, int countTries, int maxDiscardRatio) {
        int actualDiscardRatio = (countTries - countChecks) / countChecks;
        return actualDiscardRatio > maxDiscardRatio;
    }

    private List<Object> extractParams(List<Shrinkable> shrinkableParams) {
        return shrinkableParams.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private PropertyCheckResult shrinkAndCreateCheckResult(Consumer<ReportEntry> reporter, Reporting[] reporting, int countChecks, int countTries, List<Shrinkable> shrinkables, Throwable exceptionOrAssertionError) {
        PropertyShrinkingResult shrinkingResult = this.shrink(reporter, reporting, shrinkables, exceptionOrAssertionError);
        List<Object> originalParams = this.extractParams(shrinkables);
        List shrunkParams = shrinkingResult.values();
        Throwable throwable = shrinkingResult.throwable().orElse(null);
        return PropertyCheckResult.failure(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), shrunkParams, originalParams, throwable);
    }

    private PropertyShrinkingResult shrink(Consumer<ReportEntry> reporter, Reporting[] reporting, List<Shrinkable> shrinkables, Throwable exceptionOrAssertionError) {
        PropertyShrinker shrinker = new PropertyShrinker(shrinkables, this.configuration.getShrinkingMode(), reporter, reporting);
        Falsifier forAllFalsifier = this.checkedFunction::test;
        return shrinker.shrink((Falsifier<List>)forAllFalsifier, exceptionOrAssertionError);
    }
}

