/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.List;
import java.util.Optional;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.support.JqwikStringSupport;
import org.opentest4j.AssertionFailedError;

public interface PropertyCheckResult {
    public Status status();

    public String propertyName();

    public int countTries();

    public int countChecks();

    public String randomSeed();

    public Optional<List> sample();

    public Optional<List> originalSample();

    public Optional<Throwable> throwable();

    public GenerationMode generation();

    default public PropertyExecutionResult toExecutionResult() {
        if (this.status() == Status.SATISFIED) {
            return PropertyExecutionResult.successful((String)this.randomSeed());
        }
        Throwable throwable = this.throwable().orElse((Throwable)new AssertionFailedError(this.toString()));
        List sample = this.sample().orElse(null);
        return PropertyExecutionResult.failed((Throwable)throwable, (String)this.randomSeed(), (List)sample);
    }

    public static PropertyCheckResult satisfied(final String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation) {
        return new ResultBase(Status.SATISFIED, propertyName, tries, checks, randomSeed, generation){

            public String toString() {
                return String.format("%s [%s] satisfied", stereotype, this.propertyName);
            }
        };
    }

    public static PropertyCheckResult failure(final String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, final List<Object> sample, final List<Object> originalSample, final Throwable throwable) {
        Status status = PropertyCheckResult.isFalsified(throwable) ? Status.FALSIFIED : Status.ERRONEOUS;
        return new ResultBase(status, propertyName, tries, checks, randomSeed, generation){

            @Override
            public Optional<List> sample() {
                return Optional.of(sample);
            }

            @Override
            public Optional<List> originalSample() {
                return Optional.of(originalSample);
            }

            public String toString() {
                String sampleString = sample.isEmpty() ? "" : String.format(" with sample %s", JqwikStringSupport.displayString(sample));
                return String.format("%s [%s] falsified%s", stereotype, this.propertyName, sampleString);
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }
        };
    }

    public static boolean isFalsified(Throwable throwable) {
        return throwable == null || throwable instanceof AssertionError;
    }

    public static PropertyCheckResult erroneous(final String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, final List sample, final List originalSample, final Throwable throwable) {
        return new ResultBase(Status.ERRONEOUS, propertyName, tries, checks, randomSeed, generation){

            @Override
            public Optional<List> sample() {
                return Optional.ofNullable(sample);
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.of(throwable);
            }

            @Override
            public Optional<List> originalSample() {
                return Optional.ofNullable(originalSample);
            }

            public String toString() {
                return String.format("%s [%s] erroneous with sample %s and exception [%s]", stereotype, this.propertyName, sample, throwable);
            }
        };
    }

    public static PropertyCheckResult exhausted(final String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation) {
        return new ResultBase(Status.EXHAUSTED, propertyName, tries, checks, randomSeed, generation){

            public String toString() {
                int rejections = this.tries - this.checks;
                return String.format("%s [%s] exhausted after [%d] tries and [%d] rejections", stereotype, this.propertyName, this.tries, rejections);
            }
        };
    }

    public static abstract class ResultBase
    implements PropertyCheckResult {
        protected final Status status;
        protected final String propertyName;
        protected final int tries;
        protected final int checks;
        protected final String randomSeed;
        protected final GenerationMode generation;

        ResultBase(Status status, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation) {
            this.status = status;
            this.propertyName = propertyName;
            this.tries = tries;
            this.checks = checks;
            this.randomSeed = randomSeed;
            this.generation = generation;
        }

        @Override
        public String propertyName() {
            return this.propertyName;
        }

        @Override
        public Status status() {
            return this.status;
        }

        @Override
        public int countChecks() {
            return this.checks;
        }

        @Override
        public int countTries() {
            return this.tries;
        }

        @Override
        public String randomSeed() {
            return this.randomSeed;
        }

        @Override
        public Optional<List> sample() {
            return Optional.empty();
        }

        @Override
        public Optional<List> originalSample() {
            return Optional.empty();
        }

        @Override
        public Optional<Throwable> throwable() {
            return Optional.empty();
        }

        @Override
        public GenerationMode generation() {
            return this.generation;
        }
    }

    public static enum Status {
        SATISFIED,
        FALSIFIED,
        ERRONEOUS,
        EXHAUSTED;

    }
}

