/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.From;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Provide;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.RegisteredArbitraryConfigurer;
import net.jqwik.engine.properties.RegisteredArbitraryResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;

public class PropertyMethodArbitraryResolver
implements ArbitraryResolver {
    private final Class<?> containerClass;
    private final Object testInstance;
    private final RegisteredArbitraryResolver registeredArbitraryResolver;
    private final RegisteredArbitraryConfigurer registeredArbitraryConfigurer;

    public PropertyMethodArbitraryResolver(Class<?> containerClass, Object testInstance, DomainContext domainContext) {
        this(containerClass, testInstance, new RegisteredArbitraryResolver(domainContext.getArbitraryProviders()), new RegisteredArbitraryConfigurer(domainContext.getArbitraryConfigurators()));
    }

    PropertyMethodArbitraryResolver(Class<?> containerClass, Object testInstance, RegisteredArbitraryResolver registeredArbitraryResolver, RegisteredArbitraryConfigurer registeredArbitraryConfigurer) {
        this.containerClass = containerClass;
        this.testInstance = testInstance;
        this.registeredArbitraryResolver = registeredArbitraryResolver;
        this.registeredArbitraryConfigurer = registeredArbitraryConfigurer;
    }

    @Override
    public Set<Arbitrary<?>> forParameter(MethodParameter parameter) {
        TypeUsage typeUsage = TypeUsageImpl.forParameter(parameter);
        return this.createForType(typeUsage);
    }

    private Set<Arbitrary<?>> createForType(TypeUsage targetType) {
        Optional<String> optionalForAllValue = targetType.findAnnotation(ForAll.class).map(ForAll::value).filter(name -> !name.equals(""));
        Optional<String> optionalFromValue = targetType.findAnnotation(From.class).map(From::value);
        if (optionalForAllValue.isPresent() && optionalFromValue.isPresent()) {
            String message = String.format("You cannot have both @ForAll(\"%s\") and @From(\"%s\") in parameter %s", optionalForAllValue.get(), optionalFromValue.get(), targetType);
            throw new JqwikException(message);
        }
        String generatorName = optionalForAllValue.orElseGet(() -> optionalFromValue.orElse(""));
        Set resolvedArbitraries = this.findArbitraryGeneratorByName(targetType, generatorName).map(providerMethod -> this.invokeProviderMethod((Method)providerMethod, targetType)).orElseGet(() -> generatorName.equals("") ? this.resolveRegisteredArbitrary(targetType) : Collections.emptySet());
        return resolvedArbitraries.stream().map(arbitrary -> this.configure((Arbitrary<?>)arbitrary, targetType)).collect(Collectors.toSet());
    }

    private Set<Arbitrary<?>> invokeProviderMethod(Method providerMethod, TypeUsage targetType) {
        Parameter[] parameters = providerMethod.getParameters();
        if (parameters.length == 0) {
            return this.wrapInSet(JqwikReflectionSupport.invokeMethodPotentiallyOuter(providerMethod, this.testInstance, new Object[0]));
        }
        if (parameters[0].getType().isAssignableFrom(TypeUsage.class) && parameters.length == 1) {
            return this.wrapInSet(JqwikReflectionSupport.invokeMethodPotentiallyOuter(providerMethod, this.testInstance, targetType));
        }
        if (parameters[1].getType().isAssignableFrom(ArbitraryProvider.SubtypeProvider.class) && parameters.length == 2) {
            ArbitraryProvider.SubtypeProvider subtypeProvider = this::createForType;
            return this.wrapInSet(JqwikReflectionSupport.invokeMethodPotentiallyOuter(providerMethod, this.testInstance, targetType, subtypeProvider));
        }
        String message = String.format("Some of the parameters of %s are not allowed in provider methods", providerMethod);
        throw new JqwikException(message);
    }

    private Set<Arbitrary<?>> wrapInSet(Object result) {
        return Collections.singleton((Arbitrary)result);
    }

    private Arbitrary<?> configure(Arbitrary<?> createdArbitrary, TypeUsage targetType) {
        return this.registeredArbitraryConfigurer.configure(createdArbitrary, targetType);
    }

    private Optional<Method> findArbitraryGeneratorByName(TypeUsage typeUsage, String generatorToFind) {
        if (generatorToFind.isEmpty()) {
            return Optional.empty();
        }
        Function<Method, String> generatorNameSupplier = method -> {
            Optional<Provide> provideAnnotation = OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, Provide.class);
            return provideAnnotation.map(Provide::value).orElse("");
        };
        TypeUsage targetArbitraryType = TypeUsage.of(Arbitrary.class, (TypeUsage[])new TypeUsage[]{typeUsage});
        return JqwikReflectionSupport.findGeneratorMethod(generatorToFind, this.containerClass, Provide.class, generatorNameSupplier, targetArbitraryType);
    }

    private Set<Arbitrary<?>> resolveRegisteredArbitrary(TypeUsage parameterType) {
        return this.registeredArbitraryResolver.resolve(parameterType, this::createForType);
    }
}

