/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.arbitraries.randomized.ContainerGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.FrequencyGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomDecimalGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;
import net.jqwik.engine.properties.shrinking.ChooseValueShrinkable;
import net.jqwik.engine.properties.shrinking.SampleShrinkable;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;
import net.jqwik.engine.properties.shrinking.ShrinkableList;
import net.jqwik.engine.properties.shrinking.ShrinkableSet;
import net.jqwik.engine.properties.shrinking.ShrinkableString;

public class RandomGenerators {
    public static final int DEFAULT_COLLECTION_SIZE = 255;

    public static <U> RandomGenerator<U> choose(List<U> values) {
        if (values.size() == 0) {
            return RandomGenerators.fail("empty set of values");
        }
        return random -> {
            Object value = RandomGenerators.chooseValue(values, random);
            return new ChooseValueShrinkable(value, values);
        };
    }

    private static <U> U chooseValue(List<U> values, Random random) {
        int index = random.nextInt(values.size());
        return values.get(index);
    }

    public static <U> RandomGenerator<U> choose(U[] values) {
        return RandomGenerators.choose(Arrays.asList(values));
    }

    public static <T extends Enum<T>> RandomGenerator<T> choose(Class<T> enumClass) {
        return RandomGenerators.choose(enumClass.getEnumConstants());
    }

    public static RandomGenerator<Character> choose(char[] characters) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return RandomGenerators.choose(validCharacters);
    }

    public static RandomGenerator<Character> chars(char min, char max) {
        return RandomGenerators.integers(min, max).map(anInt -> Character.valueOf((char)anInt.intValue()));
    }

    public static RandomGenerator<Byte> bytes(byte min, byte max) {
        return RandomGenerators.bigIntegers(BigInteger.valueOf(min), BigInteger.valueOf(max), RandomGenerators.defaultShrinkingTargetCalculator(BigInteger.valueOf(min), BigInteger.valueOf(max)), new BigInteger[0]).map(BigInteger::byteValueExact);
    }

    public static RandomGenerator<Short> shorts(short min, short max) {
        return RandomGenerators.bigIntegers(BigInteger.valueOf(min), BigInteger.valueOf(max), RandomGenerators.defaultShrinkingTargetCalculator(BigInteger.valueOf(min), BigInteger.valueOf(max)), new BigInteger[0]).map(BigInteger::shortValueExact);
    }

    public static RandomGenerator<Integer> integers(int min, int max) {
        return RandomGenerators.bigIntegers(BigInteger.valueOf(min), BigInteger.valueOf(max), RandomGenerators.defaultShrinkingTargetCalculator(BigInteger.valueOf(min), BigInteger.valueOf(max)), new BigInteger[0]).map(BigInteger::intValueExact);
    }

    public static RandomGenerator<Long> longs(long min, long max) {
        BigInteger min1 = BigInteger.valueOf(min);
        BigInteger max1 = BigInteger.valueOf(max);
        return RandomGenerators.bigIntegers(min1, max1, RandomGenerators.defaultShrinkingTargetCalculator(min1, max1), new BigInteger[0]).map(BigInteger::longValueExact);
    }

    public static RandomGenerator<BigInteger> bigIntegers(BigInteger min, BigInteger max, Function<BigInteger, BigInteger> shrinkingTargetCalculator, BigInteger ... partitionPoints) {
        Range<BigInteger> range = Range.of(min, max);
        return RandomIntegralGenerators.bigIntegers(range, partitionPoints, shrinkingTargetCalculator);
    }

    public static RandomGenerator<Double> doubles(double min, double max, int scale) {
        return RandomGenerators.bigDecimals(BigDecimal.valueOf(min), BigDecimal.valueOf(max), scale, RandomGenerators.defaultShrinkingTargetCalculator(BigDecimal.valueOf(min), BigDecimal.valueOf(max)), new BigDecimal[0]).map(BigDecimal::doubleValue);
    }

    public static RandomGenerator<Float> floats(float min, float max, int scale) {
        return RandomGenerators.bigDecimals(BigDecimal.valueOf(min), BigDecimal.valueOf(max), scale, RandomGenerators.defaultShrinkingTargetCalculator(BigDecimal.valueOf(min), BigDecimal.valueOf(max)), new BigDecimal[0]).map(BigDecimal::floatValue);
    }

    public static RandomGenerator<BigDecimal> bigDecimals(BigDecimal min, BigDecimal max, int scale, Function<BigDecimal, BigDecimal> shrinkingTargetCalculator, BigDecimal ... partitionPoints) {
        return RandomDecimalGenerators.bigDecimals(Range.of(min, max), scale, partitionPoints, shrinkingTargetCalculator);
    }

    public static <T> RandomGenerator<List<T>> list(RandomGenerator<T> elementGenerator, int minSize, int maxSize) {
        int defaultCutoff = RandomGenerators.defaultCutoffSize(minSize, maxSize);
        return RandomGenerators.list(elementGenerator, minSize, maxSize, defaultCutoff);
    }

    public static <T> RandomGenerator<List<T>> list(RandomGenerator<T> elementGenerator, int minSize, int maxSize, int cutoffSize) {
        Function createShrinkable = elements -> new ShrinkableList(elements, minSize);
        return RandomGenerators.container(elementGenerator, createShrinkable, minSize, maxSize, cutoffSize);
    }

    public static <T> RandomGenerator<T> oneOf(List<RandomGenerator<T>> all) {
        return RandomGenerators.choose(all).flatMap(Function.identity());
    }

    public static <T> RandomGenerator<List<T>> shuffle(List<T> values) {
        return random -> {
            ArrayList clone = new ArrayList(values);
            Collections.shuffle(clone, random);
            return Shrinkable.unshrinkable(clone);
        };
    }

    public static RandomGenerator<String> strings(RandomGenerator<Character> elementGenerator, int minLength, int maxLength, int cutoffLength) {
        Function createShrinkable = elements -> new ShrinkableString((List<Shrinkable<Character>>)elements, minLength);
        return RandomGenerators.container(elementGenerator, createShrinkable, minLength, maxLength, cutoffLength);
    }

    public static RandomGenerator<String> strings(RandomGenerator<Character> elementGenerator, int minLength, int maxLength) {
        int defaultCutoff = RandomGenerators.defaultCutoffSize(minLength, maxLength);
        return RandomGenerators.strings(elementGenerator, minLength, maxLength, defaultCutoff);
    }

    private static int defaultCutoffSize(int minSize, int maxSize) {
        int range = maxSize - minSize;
        int offset = (int)Math.max(Math.round(Math.sqrt(100.0)), 10L);
        if (range <= offset) {
            return maxSize;
        }
        return Math.min(offset + minSize, maxSize);
    }

    private static <T, C> RandomGenerator<C> container(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, int minSize, int maxSize, int cutoffSize) {
        Function<Random, Integer> sizeGenerator = RandomGenerators.sizeGenerator(minSize, maxSize, cutoffSize);
        return new ContainerGenerator<T, C>(elementGenerator, createShrinkable, sizeGenerator);
    }

    private static Function<Random, Integer> sizeGenerator(int minSize, int maxSize, int cutoffSize) {
        if (cutoffSize >= maxSize) {
            return random -> RandomGenerators.randomSize(random, minSize, maxSize);
        }
        return random -> {
            if (random.nextDouble() > 0.1) {
                return RandomGenerators.randomSize(random, minSize, cutoffSize);
            }
            return RandomGenerators.randomSize(random, cutoffSize + 1, maxSize);
        };
    }

    private static int randomSize(Random random, int minSize, int maxSize) {
        int range = maxSize - minSize;
        return random.nextInt(range + 1) + minSize;
    }

    public static <T> RandomGenerator<Set<T>> set(RandomGenerator<T> elementGenerator, int minSize, int maxSize) {
        int defaultCutoffSize = RandomGenerators.defaultCutoffSize(minSize, maxSize);
        return RandomGenerators.set(elementGenerator, minSize, maxSize, defaultCutoffSize);
    }

    public static <T> RandomGenerator<Set<T>> set(RandomGenerator<T> elementGenerator, int minSize, int maxSize, int cutoffSize) {
        Function<Random, Integer> sizeGenerator = RandomGenerators.sizeGenerator(minSize, maxSize, cutoffSize);
        return random -> {
            int listSize = (Integer)sizeGenerator.apply(random);
            HashSet elements = new HashSet();
            HashSet values = new HashSet();
            MaxTriesLoop.loop(() -> elements.size() < listSize, ignore -> {
                Shrinkable next = elementGenerator.next(random);
                if (values.contains(next.value())) {
                    return Tuple.of((Object)false, (Object)ignore);
                }
                elements.add(next);
                values.add(next.value());
                return Tuple.of((Object)false, (Object)ignore);
            }, maxMisses -> {
                String message = String.format("Generating values for set of size %s missed more than %s times.", listSize, maxMisses);
                return new JqwikException(message);
            });
            return new ShrinkableSet(elements, minSize);
        };
    }

    public static <T> RandomGenerator<T> chooseShrinkable(List<Shrinkable<T>> shrinkables) {
        if (shrinkables.size() == 0) {
            return RandomGenerators.fail("empty set of shrinkables");
        }
        return random -> (Shrinkable)RandomGenerators.chooseValue(shrinkables, random);
    }

    public static <T> RandomGenerator<T> samplesFromShrinkables(List<Shrinkable<T>> samples) {
        AtomicInteger tryCount = new AtomicInteger(0);
        return ignored -> {
            if (tryCount.get() >= samples.size()) {
                tryCount.set(0);
            }
            return (Shrinkable)samples.get(tryCount.getAndIncrement());
        };
    }

    public static <T> RandomGenerator<T> samples(T[] samples) {
        List<Shrinkable<T>> shrinkables = SampleShrinkable.listOf(samples);
        return RandomGenerators.samplesFromShrinkables(shrinkables);
    }

    public static <T> RandomGenerator<T> frequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return new FrequencyGenerator<T>(frequencies);
    }

    public static <T> RandomGenerator<T> withEdgeCases(RandomGenerator<T> self, int genSize, List<Shrinkable<T>> edgeCases) {
        if (edgeCases.isEmpty()) {
            return self;
        }
        int baseToEdgeCaseRatio = Math.min(Math.max(Math.round(genSize / 5), 1), 100 / edgeCases.size()) + 1;
        RandomGenerator edgeCasesGenerator = RandomGenerators.chooseShrinkable(edgeCases);
        return random -> {
            if (random.nextInt(baseToEdgeCaseRatio) == 0) {
                return edgeCasesGenerator.next(random);
            }
            return self.next(random);
        };
    }

    public static <T> RandomGenerator<T> fail(String message) {
        return ignored -> {
            throw new JqwikException(message);
        };
    }

    public static int defaultCutoffSize(int minSize, int maxSize, int genSize) {
        int range = maxSize - minSize;
        int offset = (int)Math.max(Math.round(Math.sqrt(genSize)), 10L);
        if (range <= offset) {
            return maxSize;
        }
        return Math.min(offset + minSize, maxSize);
    }

    public static Function<BigInteger, BigInteger> defaultShrinkingTargetCalculator(BigInteger min, BigInteger max) {
        return value -> ShrinkableBigInteger.defaultShrinkingTarget(value, Range.of(min, max));
    }

    public static Function<BigDecimal, BigDecimal> defaultShrinkingTargetCalculator(BigDecimal min, BigDecimal max) {
        return value -> ShrinkableBigDecimal.defaultShrinkingTarget(value, Range.of(min, max));
    }

    public static BigInteger[] calculateDefaultPartitionPoints(int genSize, BigInteger min, BigInteger max) {
        int partitionPoint = Math.max(genSize / 2, 10);
        BigInteger upperPartitionPoint = BigInteger.valueOf(partitionPoint).min(max);
        BigInteger lowerPartitionPoint = BigInteger.valueOf(partitionPoint).negate().max(min);
        return new BigInteger[]{lowerPartitionPoint, upperPartitionPoint};
    }

    public static BigDecimal[] calculateDefaultPartitionPoints(int genSize, BigDecimal min, BigDecimal max) {
        BigInteger[] partitionPoints = RandomGenerators.calculateDefaultPartitionPoints(genSize, min.toBigInteger(), max.toBigInteger());
        return (BigDecimal[])Arrays.stream(partitionPoints).map(BigDecimal::new).toArray(BigDecimal[]::new);
    }
}

