/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.SampleShrinkable;

public class WithSamplesGenerator<T>
implements RandomGenerator<T> {
    private final AtomicInteger tryCount = new AtomicInteger(0);
    private final RandomGenerator<T> samplesGenerator;
    private final RandomGenerator<T> base;
    private final int numberOfSamples;

    public WithSamplesGenerator(RandomGenerator<T> base, T[] samples) {
        List<Shrinkable<T>> shrinkables = SampleShrinkable.listOf(samples);
        this.samplesGenerator = RandomGenerators.samplesFromShrinkables(shrinkables);
        this.numberOfSamples = shrinkables.size();
        this.base = base;
    }

    public Shrinkable<T> next(Random random) {
        if (this.tryCount.getAndIncrement() < this.numberOfSamples) {
            return this.samplesGenerator.next(random);
        }
        return this.base.next(random);
    }
}

