/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ElementsShrinkingSequence;

class ContainerShrinkingSequence<C, E>
implements ShrinkingSequence<C> {
    private final ElementsShrinkingSequence<E> elementsSequence;
    private final Function<Shrinkable<List<E>>, Shrinkable<C>> toContainerShrinkable;
    private FalsificationResult<C> currentResult;

    ContainerShrinkingSequence(List<Shrinkable<E>> currentElements, Falsifier<List<E>> listFalsifier, Function<List<Shrinkable<E>>, ShrinkingDistance> distanceFunction, Function<Shrinkable<List<E>>, Shrinkable<C>> toContainerShrinkable) {
        this.toContainerShrinkable = toContainerShrinkable;
        this.elementsSequence = new ElementsShrinkingSequence(currentElements, listFalsifier, distanceFunction);
    }

    public void init(FalsificationResult<C> initialCurrent) {
        this.currentResult = this.currentResult == null ? initialCurrent : FalsificationResult.falsified((Shrinkable)this.currentResult.shrinkable(), (Throwable)initialCurrent.throwable().orElse(null));
        this.elementsSequence.init(FalsificationResult.falsified((Shrinkable)Shrinkable.unshrinkable(new ArrayList()), (Throwable)initialCurrent.throwable().orElse(null)));
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<C>> falsifiedReporter) {
        Consumer listReporter = listResult -> falsifiedReporter.accept(this.toContainerResult((FalsificationResult<List<E>>)listResult));
        boolean next = this.elementsSequence.next(count, listReporter);
        if (next) {
            this.currentResult = this.toContainerResult(this.elementsSequence.current());
        }
        return next;
    }

    private FalsificationResult<C> toContainerResult(FalsificationResult<List<E>> listResult) {
        return listResult.map(this.toContainerShrinkable);
    }

    public FalsificationResult<C> current() {
        return this.currentResult;
    }
}

