/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Set;
import java.util.function.Consumer;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;

public class UniqueShrinkable<T>
implements Shrinkable<T> {
    private final Shrinkable<T> toFilter;
    private final Set<T> usedValues;
    private final T value;

    public UniqueShrinkable(Shrinkable<T> toFilter, Set<T> usedValues) {
        this.toFilter = toFilter;
        this.usedValues = usedValues;
        this.value = toFilter.value();
    }

    public T value() {
        return this.value;
    }

    public ShrinkingSequence<T> shrink(Falsifier<T> falsifier) {
        return new UniqueShrinkingSequence(falsifier);
    }

    public ShrinkingDistance distance() {
        return this.toFilter.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueShrinkable that = (UniqueShrinkable)o;
        return this.toFilter.equals(that.toFilter);
    }

    public int hashCode() {
        return this.toFilter.hashCode();
    }

    public String toString() {
        return String.format("Unique|%s", this.toFilter);
    }

    private class UniqueShrinkingSequence
    implements ShrinkingSequence<T> {
        private final ShrinkingSequence<T> uniqueSequence;

        private UniqueShrinkingSequence(Falsifier<T> falsifier) {
            Falsifier uniqueFalsifier = falsifier.withFilter(value -> !UniqueShrinkable.this.usedValues.contains(value));
            this.uniqueSequence = UniqueShrinkable.this.toFilter.shrink(uniqueFalsifier);
        }

        public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
            Object valueToShrink = this.uniqueSequence.current().value();
            boolean hasNext = this.uniqueSequence.next(count, falsifiedReporter);
            if (hasNext) {
                UniqueShrinkable.this.usedValues.remove(valueToShrink);
                UniqueShrinkable.this.usedValues.add(this.uniqueSequence.current().value());
            }
            return hasNext;
        }

        public void init(FalsificationResult<T> initialCurrent) {
            this.uniqueSequence.init(initialCurrent);
        }

        public FalsificationResult<T> current() {
            return this.uniqueSequence.current().map(shrinkable -> new UniqueShrinkable(shrinkable, UniqueShrinkable.this.usedValues));
        }
    }
}

