/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CombinedIterator<T>
implements Iterator<List<T>> {
    private final Iterator first;
    private final ArrayList<Iterable<T>> rest;
    private Iterator<List<T>> next;
    private Object current = null;

    public CombinedIterator(List<Iterable<T>> iterables) {
        this.rest = new ArrayList<Iterable<T>>(iterables);
        this.first = this.rest.remove(0).iterator();
        this.next = this.restIterator();
    }

    private Iterator<List<T>> restIterator() {
        return this.rest.isEmpty() ? this.emptyListIterator() : new CombinedIterator<T>(this.rest);
    }

    private Iterator<List<T>> emptyListIterator() {
        return Arrays.asList(new ArrayList()).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return this.next.hasNext() && this.first.hasNext();
        }
        return this.next.hasNext() || this.first.hasNext();
    }

    @Override
    public List<T> next() {
        if (this.next.hasNext()) {
            if (this.current == null) {
                this.current = this.first.next();
            }
        } else {
            this.current = this.first.next();
            this.next = this.restIterator();
        }
        return this.prepend(this.current, this.next.next());
    }

    private List<T> prepend(Object head, List tail) {
        ArrayList<Object> rest = new ArrayList<Object>(tail);
        rest.add(0, head);
        return rest;
    }
}

