/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.statistics;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.Reporter;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.api.statistics.StatisticsReport;
import net.jqwik.api.statistics.StatisticsReportFormat;
import net.jqwik.engine.hooks.statistics.StandardStatisticsReportFormat;
import net.jqwik.engine.hooks.statistics.StatisticsCollectorImpl;
import net.jqwik.engine.hooks.statistics.StatisticsPublisher;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class StatisticsHook
implements AroundPropertyHook {
    private static final Supplier<Map<String, StatisticsCollectorImpl>> STATISTICS_MAP_SUPPLIER = () -> new LinkedHashMap<String, StatisticsCollectorImpl>(){

        @Override
        public StatisticsCollectorImpl get(Object key) {
            return this.computeIfAbsent((String)key, StatisticsCollectorImpl::new);
        }
    };

    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        Store collectorsStore = Store.create((Object)StatisticsCollectorImpl.COLLECTORS_ID, (Lifespan)Lifespan.PROPERTY, STATISTICS_MAP_SUPPLIER);
        PropertyExecutionResult testExecutionResult = property.execute();
        Map collectors = (Map)collectorsStore.get();
        this.createStatisticsReports(collectors, context);
        if (testExecutionResult.status() == PropertyExecutionResult.Status.SUCCESSFUL) {
            return this.checkCoverages(testExecutionResult, collectors.values());
        }
        return testExecutionResult;
    }

    private PropertyExecutionResult checkCoverages(PropertyExecutionResult testExecutionResult, Collection<StatisticsCollectorImpl> collectors) {
        try {
            for (StatisticsCollectorImpl collector : collectors) {
                collector.checkCoverage();
            }
            return testExecutionResult;
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            return testExecutionResult.mapToFailed(throwable);
        }
    }

    private void createStatisticsReports(Map<String, StatisticsCollectorImpl> collectors, PropertyLifecycleContext context) {
        StandardStatisticsReportFormat reportFormat = new StandardStatisticsReportFormat();
        Optional<StatisticsReport> optionalStatisticsReport = JqwikAnnotationSupport.findAnnotationOnElementOrContainer(context.targetMethod(), StatisticsReport.class);
        if (optionalStatisticsReport.isPresent()) {
            StatisticsReport reportConfiguration = optionalStatisticsReport.get();
            if (reportConfiguration.value() == StatisticsReport.StatisticsReportMode.OFF) {
                return;
            }
            if (reportConfiguration.value() == StatisticsReport.StatisticsReportMode.PLUG_IN) {
                reportFormat = (StatisticsReportFormat)JqwikReflectionSupport.newInstanceInTestContext(reportConfiguration.format(), context.testInstance());
            }
        }
        this.report(collectors, context.reporter(), context.extendedLabel(), reportFormat);
    }

    private void report(Map<String, StatisticsCollectorImpl> collectors, Reporter reporter, String propertyName, StatisticsReportFormat reportFormat) {
        for (StatisticsCollectorImpl collector : collectors.values()) {
            StatisticsPublisher reportGenerator = new StatisticsPublisher(collector, reportFormat);
            reportGenerator.publish(reporter, propertyName);
        }
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public int aroundPropertyProximity() {
        return -50;
    }
}

