/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Reporting;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.execution.ParametersGenerator;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.properties.shrinking.PropertyShrinker;
import net.jqwik.engine.properties.shrinking.PropertyShrinkingResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.reporting.ReportEntry;

public class GenericProperty {
    private final String name;
    private final PropertyConfiguration configuration;
    private final ParametersGenerator parametersGenerator;
    private final TryLifecycleExecutor tryLifecycleExecutor;
    private final Supplier<TryLifecycleContext> tryLifecycleContextSupplier;

    public GenericProperty(String name, PropertyConfiguration configuration, ParametersGenerator parametersGenerator, TryLifecycleExecutor tryLifecycleExecutor, Supplier<TryLifecycleContext> tryLifecycleContextSupplier) {
        this.name = name;
        this.configuration = configuration;
        this.parametersGenerator = parametersGenerator;
        this.tryLifecycleExecutor = tryLifecycleExecutor;
        this.tryLifecycleContextSupplier = tryLifecycleContextSupplier;
    }

    public PropertyCheckResult check(Consumer<ReportEntry> reporter, Reporting[] reporting) {
        int maxTries = this.configuration.getTries();
        int countChecks = 0;
        int countTries = 0;
        boolean finishEarly = false;
        block7: while (countTries < maxTries && !finishEarly && this.parametersGenerator.hasNext()) {
            ++countTries;
            TryLifecycleContext tryLifecycleContext = this.tryLifecycleContextSupplier.get();
            List<Shrinkable<Object>> shrinkableParams = this.parametersGenerator.next(tryLifecycleContext);
            List<Object> sample = this.extractParams(shrinkableParams);
            try {
                ++countChecks;
                TryExecutionResult tryExecutionResult = this.testPredicate(tryLifecycleContext, sample, reporter, reporting);
                switch (tryExecutionResult.status()) {
                    case SATISFIED: {
                        finishEarly = tryExecutionResult.shouldPropertyFinishEarly();
                        continue block7;
                    }
                    case FALSIFIED: {
                        return this.shrinkAndCreateCheckResult(reporter, reporting, countChecks, countTries, shrinkableParams, sample, tryExecutionResult.throwable());
                    }
                    case INVALID: {
                        --countChecks;
                        break;
                    }
                    default: {
                        String message = String.format("Unknown TryExecutionResult.status [%s]", tryExecutionResult.status().name());
                        throw new RuntimeException(message);
                    }
                }
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                return PropertyCheckResult.failed(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), sample, null, throwable);
            }
        }
        if (countChecks == 0 || this.maxDiscardRatioExceeded(countChecks, countTries, this.configuration.getMaxDiscardRatio())) {
            return PropertyCheckResult.exhausted(this.configuration.getStereotype(), this.name, maxTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode());
        }
        return PropertyCheckResult.successful(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode());
    }

    private TryExecutionResult testPredicate(TryLifecycleContext tryLifecycleContext, List<Object> sample, Consumer<ReportEntry> reporter, Reporting[] reporting) {
        if (Reporting.GENERATED.containedIn(reporting)) {
            reporter.accept(ReportEntry.from((String)"generated", (String)JqwikStringSupport.displayString(sample)));
        }
        return this.tryLifecycleExecutor.execute(tryLifecycleContext, sample);
    }

    private boolean maxDiscardRatioExceeded(int countChecks, int countTries, int maxDiscardRatio) {
        int actualDiscardRatio = (countTries - countChecks) / countChecks;
        return actualDiscardRatio > maxDiscardRatio;
    }

    private List<Object> extractParams(List<Shrinkable<Object>> shrinkableParams) {
        return shrinkableParams.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private PropertyCheckResult shrinkAndCreateCheckResult(Consumer<ReportEntry> reporter, Reporting[] reporting, int countChecks, int countTries, List<Shrinkable<Object>> shrinkables, List<Object> originalSample, Optional<Throwable> optionalThrowable) {
        PropertyShrinkingResult shrinkingResult = this.shrink(reporter, reporting, shrinkables, optionalThrowable.orElse(null));
        List<Object> shrunkParams = shrinkingResult.values();
        Throwable throwable = shrinkingResult.throwable().orElse(null);
        return PropertyCheckResult.failed(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), shrunkParams, originalSample, throwable);
    }

    private PropertyShrinkingResult shrink(Consumer<ReportEntry> reporter, Reporting[] reporting, List<Shrinkable<Object>> shrinkables, Throwable exceptionOrAssertionError) {
        PropertyShrinker shrinker = new PropertyShrinker(shrinkables, this.configuration.getShrinkingMode(), reporter, reporting);
        Falsifier<List<Object>> forAllFalsifier = this.createFalsifier(this.tryLifecycleContextSupplier, this.tryLifecycleExecutor);
        return shrinker.shrink(forAllFalsifier, exceptionOrAssertionError);
    }

    private Falsifier<List<Object>> createFalsifier(Supplier<TryLifecycleContext> tryLifecycleContext, TryLifecycleExecutor tryExecutor) {
        return params -> tryExecutor.execute((TryLifecycleContext)tryLifecycleContext.get(), (List<Object>)params);
    }
}

