/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.ForAll;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.GenericArbitrary;
import net.jqwik.engine.support.MethodParameter;

public class RandomizedShrinkablesGenerator
implements ForAllParametersGenerator {
    private final List<RandomizedParameterGenerator> parameterGenerators;
    private final Random random;

    public static RandomizedShrinkablesGenerator forParameters(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, Random random, int genSize) {
        List<RandomizedParameterGenerator> parameterGenerators = parameters.stream().map(parameter -> RandomizedShrinkablesGenerator.resolveParameter(arbitraryResolver, parameter, genSize)).collect(Collectors.toList());
        return new RandomizedShrinkablesGenerator(parameterGenerators, random);
    }

    private static RandomizedParameterGenerator resolveParameter(ArbitraryResolver arbitraryResolver, MethodParameter parameter, int genSize) {
        Set arbitraries = arbitraryResolver.forParameter(parameter).stream().map(GenericArbitrary::new).collect(Collectors.toSet());
        if (arbitraries.isEmpty()) {
            throw new CannotFindArbitraryException(TypeUsageImpl.forParameter(parameter), parameter.getAnnotation(ForAll.class));
        }
        return new RandomizedParameterGenerator(parameter, arbitraries, genSize);
    }

    private RandomizedShrinkablesGenerator(List<RandomizedParameterGenerator> parameterGenerators, Random random) {
        this.parameterGenerators = parameterGenerators;
        this.random = random;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public List<Shrinkable<Object>> next() {
        HashMap generatorsCache = new HashMap();
        return this.parameterGenerators.stream().map(generator -> ((RandomizedParameterGenerator)generator).next(this.random, generatorsCache)).collect(Collectors.toList());
    }

    private static class RandomizedParameterGenerator {
        private final TypeUsage typeUsage;
        private final List<Arbitrary<Object>> arbitraries;
        private final int genSize;

        private RandomizedParameterGenerator(MethodParameter parameter, Set<Arbitrary<Object>> arbitraries, int genSize) {
            this.typeUsage = TypeUsageImpl.forParameter(parameter);
            this.arbitraries = new ArrayList<Arbitrary<Object>>(arbitraries);
            this.genSize = genSize;
        }

        private Shrinkable<Object> next(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
            RandomGenerator<Object> selectedGenerator = this.selectGenerator(random, arbitrariesCache);
            return selectedGenerator.next(random);
        }

        private RandomGenerator<Object> selectGenerator(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
            if (arbitrariesCache.containsKey(this.typeUsage)) {
                return arbitrariesCache.get(this.typeUsage).generator(this.genSize);
            }
            int index = this.arbitraries.size() == 1 ? 0 : random.nextInt(this.arbitraries.size());
            Arbitrary<Object> selectedArbitrary = this.arbitraries.get(index);
            arbitrariesCache.put(this.typeUsage, selectedArbitrary);
            return selectedArbitrary.generator(this.genSize);
        }
    }
}

