/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;

class DecimalGeneratingArbitrary
implements Arbitrary<BigDecimal> {
    private static final int DEFAULT_SCALE = 2;
    Range<BigDecimal> range;
    int scale = 2;
    BigDecimal shrinkingTarget;

    DecimalGeneratingArbitrary(Range<BigDecimal> defaultRange) {
        this.range = defaultRange;
        this.shrinkingTarget = null;
    }

    public RandomGenerator<BigDecimal> generator(int genSize) {
        BigDecimal[] partitionPoints = RandomGenerators.calculateDefaultPartitionPoints(genSize, this.range);
        return this.decimalGenerator(partitionPoints, genSize);
    }

    public Optional<ExhaustiveGenerator<BigDecimal>> exhaustive(long maxNumberOfSamples) {
        if (this.range.isSingular()) {
            return ExhaustiveGenerators.choose(Collections.singletonList(this.range.min), maxNumberOfSamples);
        }
        return Optional.empty();
    }

    private RandomGenerator<BigDecimal> decimalGenerator(BigDecimal[] partitionPoints, int genSize) {
        List edgeCases = this.streamEdgeCases().filter(aDecimal -> this.range.includes((BigDecimal)aDecimal)).map(value -> new ShrinkableBigDecimal((BigDecimal)value, this.range, this.scale, this.shrinkingTarget((BigDecimal)value))).collect(Collectors.toList());
        return RandomGenerators.bigDecimals(this.range, this.scale, this.shrinkingTargetCalculator(), partitionPoints).withEdgeCases(genSize, edgeCases);
    }

    private Stream<BigDecimal> streamEdgeCases() {
        BigDecimal smallest = BigDecimal.ONE.movePointLeft(this.scale);
        BigDecimal zeroScaled = BigDecimal.ZERO.movePointLeft(this.scale);
        BigDecimal[] literalEdgeCases = new BigDecimal[]{zeroScaled, zeroScaled, zeroScaled, BigDecimal.ONE, BigDecimal.ONE.negate(), smallest, smallest.negate(), (BigDecimal)this.range.min, (BigDecimal)this.range.max};
        return this.shrinkingTarget == null ? Arrays.stream(literalEdgeCases) : Stream.concat(Stream.of(this.shrinkingTarget), Arrays.stream(literalEdgeCases));
    }

    private Function<BigDecimal, BigDecimal> shrinkingTargetCalculator() {
        if (this.shrinkingTarget == null) {
            return RandomGenerators.defaultShrinkingTargetCalculator(this.range, this.scale);
        }
        return ignore -> this.shrinkingTarget;
    }

    private BigDecimal shrinkingTarget(BigDecimal aDecimal) {
        return this.shrinkingTargetCalculator().apply(aDecimal);
    }
}

