/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

public class RandomIntegralGenerators {
    public static RandomGenerator<BigInteger> bigIntegers(Range<BigInteger> range, BigInteger[] partitionPoints, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        if (range.isSingular()) {
            return ignored -> Shrinkable.unshrinkable(range.min);
        }
        return RandomIntegralGenerators.partitionedGenerator(range, partitionPoints, shrinkingTargetCalculator);
    }

    private static RandomGenerator<BigInteger> partitionedGenerator(Range<BigInteger> range, BigInteger[] partitionPoints, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        List<RandomGenerator<BigInteger>> generators = RandomIntegralGenerators.createPartitions(range, partitionPoints, shrinkingTargetCalculator);
        if (generators.size() == 1) {
            return generators.get(0);
        }
        return random -> ((RandomGenerator)generators.get(random.nextInt(generators.size()))).next(random);
    }

    private static List<RandomGenerator<BigInteger>> createPartitions(Range<BigInteger> range, BigInteger[] partitionPoints, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        ArrayList<RandomGenerator<BigInteger>> partitions = new ArrayList<RandomGenerator<BigInteger>>();
        Arrays.sort(partitionPoints);
        BigInteger lower = (BigInteger)range.min;
        for (BigInteger partitionPoint : partitionPoints) {
            BigInteger upper = partitionPoint;
            if (upper.compareTo(lower) <= 0) continue;
            if (upper.compareTo((BigInteger)range.max) >= 0) break;
            partitions.add(RandomIntegralGenerators.createBaseGenerator(lower, upper.subtract(BigInteger.ONE), range, shrinkingTargetCalculator));
            lower = upper;
        }
        partitions.add(RandomIntegralGenerators.createBaseGenerator(lower, (BigInteger)range.max, range, shrinkingTargetCalculator));
        return partitions;
    }

    private static RandomGenerator<BigInteger> createBaseGenerator(BigInteger minGenerate, BigInteger maxGenerate, Range<BigInteger> shrinkingRange, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        if (RandomIntegralGenerators.isWithinIntegerRange(minGenerate, maxGenerate)) {
            return RandomIntegralGenerators.createIntegerGenerator(minGenerate, maxGenerate, shrinkingRange, shrinkingTargetCalculator);
        }
        return RandomIntegralGenerators.createBigIntegerGenerator(minGenerate, maxGenerate, shrinkingRange, shrinkingTargetCalculator);
    }

    private static RandomGenerator<BigInteger> createBigIntegerGenerator(BigInteger minGenerate, BigInteger maxGenerate, Range<BigInteger> shrinkingRange, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        BigInteger range = maxGenerate.subtract(minGenerate);
        int bits = range.bitLength();
        return random -> {
            BigInteger rawValue;
            BigInteger value;
            while ((value = (rawValue = new BigInteger(bits, random)).add(minGenerate)).compareTo(minGenerate) < 0 || value.compareTo(maxGenerate) > 0) {
            }
            return new ShrinkableBigInteger(value, shrinkingRange, (BigInteger)shrinkingTargetCalculator.apply(value));
        };
    }

    private static RandomGenerator<BigInteger> createIntegerGenerator(BigInteger min, BigInteger max, Range<BigInteger> shrinkingRange, Function<BigInteger, BigInteger> shrinkingTargetCalculator) {
        int _min = Math.min(min.intValue(), max.intValue());
        int _max = Math.max(min.intValue(), max.intValue());
        return random -> {
            int bound = Math.abs(_max - _min) + 1;
            int value = random.nextInt(bound >= 0 ? bound : Integer.MAX_VALUE) + _min;
            BigInteger bigIntegerValue = BigInteger.valueOf(value);
            return new ShrinkableBigInteger(bigIntegerValue, shrinkingRange, (BigInteger)shrinkingTargetCalculator.apply(bigIntegerValue));
        };
    }

    private static boolean isWithinIntegerRange(BigInteger min, BigInteger max) {
        return min.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0 && max.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0;
    }
}

