/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import net.jqwik.api.JqwikException;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.BigRange;
import net.jqwik.api.constraints.ByteRange;
import net.jqwik.api.constraints.DoubleRange;
import net.jqwik.api.constraints.FloatRange;
import net.jqwik.api.constraints.IntRange;
import net.jqwik.api.constraints.LongRange;
import net.jqwik.api.constraints.ShortRange;

public class RangeConfigurator
extends ArbitraryConfiguratorBase {
    public BigDecimalArbitrary configure(BigDecimalArbitrary arbitrary, BigRange range) {
        BigDecimal min = RangeConfigurator.evaluate(range.min(), BigDecimal::new);
        BigDecimal max = RangeConfigurator.evaluate(range.max(), BigDecimal::new);
        return arbitrary.between(min, range.minIncluded(), max, range.maxIncluded());
    }

    public BigIntegerArbitrary configure(BigIntegerArbitrary arbitrary, BigRange range) {
        BigInteger min = RangeConfigurator.evaluate(range.min(), val -> new BigDecimal((String)val).toBigIntegerExact());
        BigInteger max = RangeConfigurator.evaluate(range.max(), val -> new BigDecimal((String)val).toBigIntegerExact());
        if (!range.minIncluded() || !range.maxIncluded()) {
            String message = "minIncluded and maxIncluded are only allowed for parameters of type java.math.BigDecimal";
            throw new JqwikException(message);
        }
        return arbitrary.greaterOrEqual(min).lessOrEqual(max);
    }

    private static <T> T evaluate(String valueString, Function<String, T> evaluator) {
        return valueString.isEmpty() ? null : (T)evaluator.apply(valueString);
    }

    public ByteArbitrary configure(ByteArbitrary arbitrary, ByteRange range) {
        return arbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
    }

    public DoubleArbitrary configure(DoubleArbitrary arbitrary, DoubleRange range) {
        return arbitrary.between(range.min(), range.minIncluded(), range.max(), range.maxIncluded());
    }

    public FloatArbitrary configure(FloatArbitrary arbitrary, FloatRange range) {
        return arbitrary.between(range.min(), range.minIncluded(), range.max(), range.maxIncluded());
    }

    public IntegerArbitrary configure(IntegerArbitrary arbitrary, IntRange range) {
        return arbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
    }

    public LongArbitrary configure(LongArbitrary arbitrary, LongRange range) {
        return arbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
    }

    public ShortArbitrary configure(ShortArbitrary arbitrary, ShortRange range) {
        return arbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
    }
}

