/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.CollectShrinkable;

class CollectShrinkingSequence<T>
implements ShrinkingSequence<List<T>> {
    private final Predicate<List<T>> until;
    private final Falsifier<List<T>> falsifier;
    private List<Shrinkable<T>> elements;
    private FalsificationResult<List<T>> current;
    private ShrinkingSequence<T> currentShrinkingSequence = null;
    private int currentShrinkingIndex = 0;

    CollectShrinkingSequence(List<Shrinkable<T>> elements, Predicate<List<T>> until, Falsifier<List<T>> falsifier) {
        this.elements = elements;
        this.until = until;
        this.falsifier = falsifier;
    }

    private ShrinkingSequence<T> getShrinkingSequence(int shrinkingPosition) {
        Falsifier elementFalsifier = value -> {
            List<Object> currentValues = this.collectValues(shrinkingPosition, value);
            return this.falsifier.execute(currentValues);
        };
        return this.elements.get(shrinkingPosition).shrink(elementFalsifier);
    }

    private List<Shrinkable<T>> collectShrinkables(int replaceIndex, Shrinkable<T> replaceShrinkable) {
        ArrayList<Shrinkable<T>> collectedShrinkables = new ArrayList<Shrinkable<T>>();
        for (int i = 0; i < this.elements.size() && !this.until.test(this.toValues(collectedShrinkables)); ++i) {
            Shrinkable<T> shrinkable = this.elements.get(i);
            if (i == replaceIndex) {
                shrinkable = replaceShrinkable;
            }
            collectedShrinkables.add(shrinkable);
        }
        return collectedShrinkables;
    }

    private List<T> toValues(List<Shrinkable<T>> collectedShrinkables) {
        return collectedShrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private List<T> collectValues(int replaceIndex, T replaceValue) {
        Shrinkable replaceShrinkable = Shrinkable.unshrinkable(replaceValue);
        return this.toValues(this.collectShrinkables(replaceIndex, replaceShrinkable));
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        while (this.currentShrinkingIndex < this.elements.size()) {
            Consumer<FalsificationResult<T>> elementReporter;
            boolean next;
            if (this.currentShrinkingSequence == null) {
                this.currentShrinkingSequence = this.getShrinkingSequence(this.currentShrinkingIndex);
            }
            if (!(next = this.currentShrinkingSequence.next(count, elementReporter = this.createElementReporter(falsifiedReporter, this.currentShrinkingIndex)))) {
                this.currentShrinkingSequence = null;
                ++this.currentShrinkingIndex;
                continue;
            }
            this.elements = this.collectShrinkables(this.currentShrinkingIndex, this.currentShrinkingSequence.current().shrinkable());
            this.current = this.currentShrinkingSequence.current().map(shrinkable -> new CollectShrinkable<T>(this.elements, this.until));
            return true;
        }
        return false;
    }

    private Consumer<FalsificationResult<T>> createElementReporter(Consumer<FalsificationResult<List<T>>> falsifiedReporter, int elementIndex) {
        return elementResult -> {
            FalsificationResult listResult = elementResult.map(shrinkable -> new CollectShrinkable<T>(this.collectShrinkables(elementIndex, (Shrinkable<T>)shrinkable), this.until));
            falsifiedReporter.accept(listResult);
        };
    }

    public FalsificationResult<List<T>> current() {
        return this.current;
    }

    public void init(FalsificationResult<List<T>> initialCurrent) {
        this.current = initialCurrent;
    }
}

