/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ContainerShrinkingSequence;
import net.jqwik.engine.properties.shrinking.DeepSearchShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ListShrinkingCandidates;

abstract class ShrinkableContainer<C, E>
implements Shrinkable<C> {
    private final List<Shrinkable<E>> elements;
    private final ListShrinkingCandidates<Shrinkable<E>> shrinkCandidates;
    private final C value;

    ShrinkableContainer(List<Shrinkable<E>> elements, int minSize) {
        this.elements = elements;
        this.shrinkCandidates = new ListShrinkingCandidates(minSize);
        this.value = this.createValue(elements);
    }

    private C createValue(List<Shrinkable<E>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(this.containerCollector());
    }

    public C value() {
        return this.value;
    }

    public ShrinkingSequence<C> shrink(Falsifier<C> falsifier) {
        return new DeepSearchShrinkingSequence(this, this::shrinkCandidatesFor, falsifier).andThen(shrinkableList -> {
            List<Shrinkable<E>> elements = ((ShrinkableContainer)shrinkableList).elements;
            Falsifier listFalsifier = list -> falsifier.execute(this.toContainer((List<E>)list));
            return new ContainerShrinkingSequence(elements, listFalsifier, ShrinkingDistance::forCollection, this::toContainerShrinkable);
        }).andThen(shrinkableContainer -> new DeepSearchShrinkingSequence(shrinkableContainer, this::shrinkCandidatesFor, falsifier));
    }

    public List<Shrinkable<C>> shrinkingSuggestions() {
        ArrayList<Shrinkable<C>> shrinkables = new ArrayList<Shrinkable<C>>(this.shrinkCandidatesFor(this));
        shrinkables.addAll(super.shrinkingSuggestions());
        shrinkables.sort(null);
        return shrinkables;
    }

    private C toContainer(List<E> listOfE) {
        return listOfE.stream().collect(this.containerCollector());
    }

    private Shrinkable<C> toContainerShrinkable(Shrinkable<List<E>> listOfShrinkable) {
        List<Shrinkable<E>> shrinkableElements = ((List)listOfShrinkable.value()).stream().map(Shrinkable::unshrinkable).collect(Collectors.toList());
        return this.createShrinkable(shrinkableElements);
    }

    private Set<Shrinkable<C>> shrinkCandidatesFor(Shrinkable<C> shrinkable) {
        ShrinkableContainer listShrinkable = (ShrinkableContainer)shrinkable;
        return this.shrinkCandidates.candidatesFor(listShrinkable.elements).stream().map(this::createShrinkable).collect(Collectors.toSet());
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.forCollection(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkableContainer that = (ShrinkableContainer)o;
        return this.value().equals(that.value());
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public String toString() {
        return String.format("%s<%s>(%s:%s)", this.getClass().getSimpleName(), this.value().getClass().getSimpleName(), this.value(), this.distance());
    }

    abstract Shrinkable<C> createShrinkable(List<Shrinkable<E>> var1);

    abstract Collector<E, ?, C> containerCollector();
}

