/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.function.Consumer;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.lifecycle.TryExecutionResult;

public class StartWithShrinkingSequence<T>
implements ShrinkingSequence<T> {
    private final Shrinkable<T> starter;
    private final Falsifier<T> falsifier;
    private FalsificationResult<T> current;
    private ShrinkingSequence<T> startersSequence;

    public StartWithShrinkingSequence(Shrinkable<T> starter, Falsifier<T> falsifier) {
        this.starter = starter;
        this.falsifier = falsifier;
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
        if (this.startersSequence != null) {
            boolean next = this.startersSequence.next(count, falsifiedReporter);
            this.current = this.startersSequence.current();
            return next;
        }
        if (this.falsifier.execute(this.starter.value()).status() == TryExecutionResult.Status.SATISFIED) {
            return false;
        }
        this.startersSequence = this.starter.shrink(this.falsifier);
        this.current = this.current.map(ignore -> this.starter);
        return true;
    }

    public FalsificationResult<T> current() {
        return this.current;
    }

    public void init(FalsificationResult<T> initialCurrent) {
        this.current = initialCurrent;
    }
}

