/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.engine.properties.stateful.ActionGenerator;
import net.jqwik.engine.properties.stateful.ListActionGenerator;
import net.jqwik.engine.properties.stateful.SequentialActionSequence;
import net.jqwik.engine.support.JqwikStringSupport;

class FixedActionsFailedActionSequence<M>
extends SequentialActionSequence<M>
implements Externalizable {
    private List<Action<M>> listOfActions;

    FixedActionsFailedActionSequence(List<Action<M>> listOfActions) {
        super(FixedActionsFailedActionSequence.createGenerator(listOfActions), listOfActions.size());
        this.runState = ActionSequence.RunState.FAILED;
        this.listOfActions = listOfActions;
        this.sequence.addAll(listOfActions);
    }

    public FixedActionsFailedActionSequence() {
        super(FixedActionsFailedActionSequence.createGenerator(new ArrayList<Action<M>>()), 1);
        this.listOfActions = new ArrayList<Action<M>>();
    }

    @Override
    public String toString() {
        String actionsString = JqwikStringSupport.displayString(this.runActions());
        return String.format("ActionSequence: %s", actionsString);
    }

    @Override
    public synchronized M run(M model) {
        this.runState = ActionSequence.RunState.NOT_RUN;
        this.sequence.clear();
        return super.run(model);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listOfActions);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listOfActions = (List)in.readObject();
        this.runState = ActionSequence.RunState.FAILED;
        this.actionGenerator = FixedActionsFailedActionSequence.createGenerator(this.listOfActions);
        this.intendedSize = this.listOfActions.size();
        this.sequence.addAll(this.listOfActions);
    }

    private static <M> ActionGenerator<M> createGenerator(List<Action<M>> listOfActions) {
        return new ListActionGenerator(listOfActions);
    }
}

