/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.engine.properties.shrinking.DeepSearchShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ShrinkElementsSequence;
import net.jqwik.engine.properties.shrinking.ShrinkableList;
import net.jqwik.engine.properties.stateful.ActionGenerator;
import net.jqwik.engine.properties.stateful.ComprehensiveListShrinkingCandidates;
import net.jqwik.engine.properties.stateful.FixedActionsFailedActionSequence;
import net.jqwik.engine.properties.stateful.ListActionGenerator;
import net.jqwik.engine.properties.stateful.SequentialActionSequence;
import net.jqwik.engine.properties.stateful.ShrinkablesActionGenerator;

class ShrinkableActionSequence<T>
implements Shrinkable<ActionSequence<T>> {
    private final ComprehensiveListShrinkingCandidates listShrinkingCandidates = new ComprehensiveListShrinkingCandidates();
    private final ActionSequence<T> value;
    private final ActionGenerator<T> actionGenerator;
    private final int minSize;
    private final ShrinkingDistance distance;

    ShrinkableActionSequence(ActionGenerator<T> actionGenerator, int minSize, int maxSize, ShrinkingDistance distance) {
        this.actionGenerator = actionGenerator;
        this.minSize = minSize;
        this.distance = distance;
        this.value = new SequentialActionSequence<T>(actionGenerator, maxSize);
    }

    public ActionSequence<T> value() {
        return this.value;
    }

    public ShrinkingSequence<ActionSequence<T>> shrink(Falsifier<ActionSequence<T>> falsifier) {
        Falsifier minRespectingFalsifier = falsifier.withPostFilter(actionSequence -> actionSequence.runActions().size() >= this.minSize);
        return this.shrinkSequenceOfActions(minRespectingFalsifier).andThen(shrinkableList -> {
            ShrinkableActionSequence shrinkableSequence = (ShrinkableActionSequence)shrinkableList;
            Falsifier listFalsifier = list -> minRespectingFalsifier.execute(this.toRunnableActionSequence((List<Action<T>>)list));
            return this.shrinkIndividualActions(shrinkableSequence, listFalsifier).andThen(this.shrinkListOfActions(listFalsifier)).mapValue(this::toDisplayOnlyActionSequence);
        });
    }

    private Function<Shrinkable<List<Action<T>>>, ShrinkingSequence<List<Action<T>>>> shrinkListOfActions(Falsifier<List<Action<T>>> listFalsifier) {
        return shrinkableListOfActions -> new DeepSearchShrinkingSequence(shrinkableListOfActions, this::shrinkActionListCandidates, listFalsifier);
    }

    private Set<Shrinkable<List<Action<T>>>> shrinkActionListCandidates(Shrinkable<List<Action<T>>> shrinkableList) {
        return this.listShrinkingCandidates.candidatesFor((List)shrinkableList.value()).stream().map(elements -> elements.stream().map(Shrinkable::unshrinkable).collect(Collectors.toList())).map(shrinkableElements -> new ShrinkableList(shrinkableElements, 1)).collect(Collectors.toSet());
    }

    private ShrinkingSequence<List<Action<T>>> shrinkIndividualActions(ShrinkableActionSequence<T> shrinkableActionSequence, Falsifier<List<Action<T>>> listFalsifier) {
        return new ShrinkElementsSequence<Action<T>>(shrinkableActionSequence.actionGenerator.generated(), listFalsifier, ShrinkingDistance::forCollection);
    }

    private ActionSequence<T> toDisplayOnlyActionSequence(List<Action<T>> listOfActions) {
        return new FixedActionsFailedActionSequence(listOfActions);
    }

    private ActionSequence<T> toRunnableActionSequence(List<Action<T>> listOfActions) {
        ListActionGenerator<T> newActionGenerator = new ListActionGenerator<T>(listOfActions);
        return new SequentialActionSequence<T>(newActionGenerator, listOfActions.size());
    }

    private ShrinkableActionSequence<T> toShrinkableActionSequence(List<Shrinkable<Action<T>>> list) {
        ShrinkablesActionGenerator<T> newGenerator = new ShrinkablesActionGenerator<T>(list);
        ShrinkingDistance newDistance = ShrinkingDistance.forCollection(list);
        return new ShrinkableActionSequence<T>(newGenerator, 1, list.size(), newDistance);
    }

    private DeepSearchShrinkingSequence<ActionSequence<T>> shrinkSequenceOfActions(Falsifier<ActionSequence<T>> falsifier) {
        return new DeepSearchShrinkingSequence<ActionSequence<T>>(this, this::shrinkSequenceCandidates, falsifier);
    }

    private Set<Shrinkable<ActionSequence<T>>> shrinkSequenceCandidates(Shrinkable<ActionSequence<T>> shrinkable) {
        ShrinkableActionSequence shrinkableSequence = (ShrinkableActionSequence)shrinkable;
        return this.listShrinkingCandidates.candidatesFor(shrinkableSequence.actionGenerator.generated()).stream().map(this::toShrinkableActionSequence).collect(Collectors.toSet());
    }

    public ShrinkingDistance distance() {
        if (this.value.runState() == ActionSequence.RunState.NOT_RUN) {
            return this.distance;
        }
        return ShrinkingDistance.forCollection(this.actionGenerator.generated());
    }
}

