/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.util.Optional;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.Property;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.PropertyAttributes;

public class DefaultPropertyAttributes
implements PropertyAttributes {
    private Integer tries;
    private Integer maxDiscardRatio;
    private ShrinkingMode shrinkingMode;
    private GenerationMode generationMode;
    private AfterFailureMode afterFailureMode;
    private EdgeCasesMode edgeCasesMode;
    private String stereotype;
    private String seed;

    public static PropertyAttributes from(Property property) {
        Integer tries = property.tries() == 0 ? null : Integer.valueOf(property.tries());
        Integer maxDiscardRatio = property.maxDiscardRatio() == 0 ? null : Integer.valueOf(property.maxDiscardRatio());
        ShrinkingMode shrinking = property.shrinking() == ShrinkingMode.NOT_SET ? null : property.shrinking();
        AfterFailureMode afterFailure = property.afterFailure() == AfterFailureMode.NOT_SET ? null : property.afterFailure();
        GenerationMode generation = property.generation() == GenerationMode.NOT_SET ? null : property.generation();
        EdgeCasesMode edgeCases = property.edgeCases() == EdgeCasesMode.NOT_SET ? null : property.edgeCases();
        String stereotype = property.stereotype().equals("") ? null : property.stereotype();
        String seed = property.seed().equals("") ? null : property.seed();
        return new DefaultPropertyAttributes(tries, maxDiscardRatio, shrinking, generation, afterFailure, edgeCases, stereotype, seed);
    }

    public DefaultPropertyAttributes(Integer tries, Integer maxDiscardRatio, ShrinkingMode shrinkingMode, GenerationMode generationMode, AfterFailureMode afterFailureMode, EdgeCasesMode edgeCasesMode, String stereotype, String seed) {
        this.tries = tries;
        this.maxDiscardRatio = maxDiscardRatio;
        this.shrinkingMode = shrinkingMode;
        this.generationMode = generationMode;
        this.afterFailureMode = afterFailureMode;
        this.edgeCasesMode = edgeCasesMode;
        this.stereotype = stereotype;
        this.seed = seed;
    }

    public Optional<Integer> tries() {
        return Optional.ofNullable(this.tries);
    }

    public Optional<Integer> maxDiscardRatio() {
        return Optional.ofNullable(this.maxDiscardRatio);
    }

    public Optional<ShrinkingMode> shrinking() {
        return Optional.ofNullable(this.shrinkingMode);
    }

    public Optional<GenerationMode> generation() {
        return Optional.ofNullable(this.generationMode);
    }

    public Optional<AfterFailureMode> afterFailure() {
        return Optional.ofNullable(this.afterFailureMode);
    }

    public Optional<EdgeCasesMode> edgeCases() {
        return Optional.ofNullable(this.edgeCasesMode);
    }

    public Optional<String> stereotype() {
        return Optional.ofNullable(this.stereotype);
    }

    public Optional<String> seed() {
        return Optional.ofNullable(this.seed);
    }

    public void setTries(Integer tries) {
        this.tries = tries;
    }

    public void setMaxDiscardRatio(Integer maxDiscardRatio) {
        this.maxDiscardRatio = maxDiscardRatio;
    }

    public void setShrinking(ShrinkingMode shrinkingMode) {
        this.shrinkingMode = shrinkingMode;
    }

    public void setGeneration(GenerationMode generationMode) {
        this.generationMode = generationMode;
    }

    public void setAfterFailure(AfterFailureMode afterFailureMode) {
        this.afterFailureMode = afterFailureMode;
    }

    public void setEdgeCases(EdgeCasesMode edgeCasesMode) {
        this.edgeCasesMode = edgeCasesMode;
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }
}

