/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Property;
import net.jqwik.api.lifecycle.PropertyAttributes;
import net.jqwik.engine.PropertyAttributesDefaults;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.descriptor.SkipExecutionDecorator;
import net.jqwik.engine.discovery.DefaultPropertyAttributes;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.JqwikUniqueIDs;
import net.jqwik.engine.discovery.specs.PropertyDiscoverySpec;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.recording.TestRunData;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

class PropertyMethodResolver
implements ElementResolver {
    private final PropertyDiscoverySpec methodSpec = new PropertyDiscoverySpec();
    private final TestRunData testRunData;
    private final PropertyAttributesDefaults propertyDefaultValues;

    PropertyMethodResolver(TestRunData testRunData, PropertyAttributesDefaults propertyDefaultValues) {
        this.testRunData = testRunData;
        this.propertyDefaultValues = propertyDefaultValues;
    }

    @Override
    public Set<TestDescriptor> resolveElement(AnnotatedElement element, TestDescriptor parent) {
        if (!(element instanceof Method)) {
            return Collections.emptySet();
        }
        if (!(parent instanceof ContainerClassDescriptor)) {
            return Collections.emptySet();
        }
        Method method = (Method)element;
        if (!this.isRelevantMethod(method)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.createTestDescriptor(parent, method));
    }

    @Override
    public Optional<TestDescriptor> resolveUniqueId(UniqueId.Segment segment, TestDescriptor parent) {
        if (!segment.getType().equals(this.getSegmentType())) {
            return Optional.empty();
        }
        if (!(parent instanceof ContainerClassDescriptor)) {
            return Optional.empty();
        }
        Optional<Method> optionalMethod = this.findMethod(segment, (ContainerClassDescriptor)parent);
        if (!optionalMethod.isPresent()) {
            return Optional.empty();
        }
        Method method = optionalMethod.get();
        if (!this.isRelevantMethod(method)) {
            return Optional.empty();
        }
        return Optional.of(this.createTestDescriptor(parent, method));
    }

    private boolean isRelevantMethod(Method candidate) {
        return this.methodSpec.shouldBeDiscovered(candidate);
    }

    private Optional<Method> findMethod(UniqueId.Segment segment, ContainerClassDescriptor parent) {
        return JqwikUniqueIDs.findMethodBySegment(segment, parent.getContainerClass());
    }

    private TestDescriptor createTestDescriptor(TestDescriptor parent, Method method) {
        UniqueId uniqueId = this.createUniqueId(method, parent);
        Class<?> testClass = ((ContainerClassDescriptor)parent).getContainerClass();
        TestDescriptor newDescriptor = this.createTestDescriptor(uniqueId, testClass, method);
        Node.SkipResult shouldBeSkipped = this.methodSpec.shouldBeSkipped(method);
        if (shouldBeSkipped.isSkipped()) {
            return new SkipExecutionDecorator(newDescriptor, shouldBeSkipped.getReason().orElse(""));
        }
        return newDescriptor;
    }

    private TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method) {
        Property property = (Property)AnnotationSupport.findAnnotation((AnnotatedElement)method, Property.class).orElseThrow(() -> {
            String message = String.format("Method [%s] is not annotated with @Property", method);
            return new JqwikException(message);
        });
        String previousSeed = this.previousSeed(uniqueId);
        List<Object> falsifiedSample = this.falsifiedSample(uniqueId);
        PropertyAttributes attributes = DefaultPropertyAttributes.from(property);
        PropertyConfiguration propertyConfig = PropertyConfiguration.from(attributes, this.propertyDefaultValues, previousSeed, falsifiedSample);
        return new PropertyMethodDescriptor(uniqueId, method, testClass, propertyConfig);
    }

    private String previousSeed(UniqueId uniqueId) {
        return this.testRunData.byUniqueId(uniqueId).filter(TestRun::isNotSuccessful).flatMap(TestRun::randomSeed).orElse(null);
    }

    private List<Object> falsifiedSample(UniqueId uniqueId) {
        return this.testRunData.byUniqueId(uniqueId).filter(TestRun::isNotSuccessful).flatMap(TestRun::falsifiedSample).orElse(null);
    }

    private String getSegmentType() {
        return "property";
    }

    private UniqueId createUniqueId(Method method, TestDescriptor parent) {
        return JqwikUniqueIDs.appendProperty(parent.getUniqueId(), method);
    }
}

