/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.io.Serializable;
import java.util.List;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.ReportEntrySupport;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.recording.TestRunRecorder;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;

public class RecordingExecutionListener
implements PropertyExecutionListener {
    private final TestRunRecorder recorder;
    private final EngineExecutionListener listener;
    private final boolean useJunitPlatformReporter;

    RecordingExecutionListener(TestRunRecorder recorder, EngineExecutionListener listener, boolean useJunitPlatformReporter) {
        this.recorder = recorder;
        this.listener = listener;
        this.useJunitPlatformReporter = useJunitPlatformReporter;
    }

    @Override
    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.listener.executionSkipped(testDescriptor, reason);
    }

    @Override
    public void executionStarted(TestDescriptor testDescriptor) {
        this.listener.executionStarted(testDescriptor);
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, PropertyExecutionResult executionResult) {
        this.recordTestRun(testDescriptor, executionResult);
        this.listener.executionFinished(testDescriptor, this.toTestExecutionResult(executionResult));
    }

    private TestExecutionResult toTestExecutionResult(PropertyExecutionResult executionResult) {
        if (executionResult.status() == PropertyExecutionResult.Status.SUCCESSFUL) {
            return TestExecutionResult.successful();
        }
        if (executionResult.status() == PropertyExecutionResult.Status.FAILED) {
            return TestExecutionResult.failed((Throwable)executionResult.throwable().orElse(null));
        }
        if (executionResult.status() == PropertyExecutionResult.Status.ABORTED) {
            return TestExecutionResult.aborted((Throwable)executionResult.throwable().orElse(null));
        }
        throw new IllegalArgumentException("No other status possible");
    }

    private void recordTestRun(TestDescriptor testDescriptor, PropertyExecutionResult executionResult) {
        String seed = executionResult.seed().orElse(null);
        List sample = executionResult.falsifiedParameters().filter(this::isSerializable).orElse(null);
        TestRun run = new TestRun(testDescriptor.getUniqueId(), executionResult.status(), seed, sample);
        this.recorder.record(run);
    }

    private boolean isSerializable(List<Object> sample) {
        if (!(sample instanceof Serializable)) {
            return false;
        }
        return sample.stream().allMatch(e -> e instanceof Serializable);
    }

    @Override
    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        if (this.useJunitPlatformReporter) {
            this.listener.reportingEntryPublished(testDescriptor, entry);
        } else {
            ReportEntrySupport.printToStdout(testDescriptor, entry);
        }
    }
}

