/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.support.Combinatorics;

public class EdgeCasesGenerator
implements Iterator<List<Shrinkable<Object>>> {
    private final List<EdgeCases<Object>> edgeCases;
    private final Iterator<List<Shrinkable<Object>>> iterator;

    public static int calculateBaseToEdgeCaseRatio(int genSize, int countEdgeCases) {
        return Math.min(Math.max(genSize / countEdgeCases, 3), 20);
    }

    EdgeCasesGenerator(List<EdgeCases<Object>> edgeCases) {
        this.edgeCases = edgeCases;
        this.iterator = this.createIterator();
    }

    private Iterator<List<Shrinkable<Object>>> createIterator() {
        if (this.edgeCases.isEmpty()) {
            return Collections.emptyIterator();
        }
        List iterables = this.edgeCases.stream().map(edge -> edge).collect(Collectors.toList());
        return Combinatorics.combine(iterables);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<Shrinkable<Object>> next() {
        return this.iterator.next();
    }
}

