/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Optional;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;

public class DefaultDoubleArbitrary
extends AbstractArbitraryBase
implements DoubleArbitrary {
    private static final double DEFAULT_MIN = -1.7976931348623157E308;
    private static final double DEFAULT_MAX = Double.MAX_VALUE;
    private final DecimalGeneratingArbitrary generatingArbitrary = new DecimalGeneratingArbitrary(Range.of(this.toBigDecimal(-1.7976931348623157E308), this.toBigDecimal(Double.MAX_VALUE)));

    public RandomGenerator<Double> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigDecimal::doubleValue);
    }

    public Optional<ExhaustiveGenerator<Double>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigDecimal::doubleValue));
    }

    public EdgeCases<Double> edgeCases() {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(), BigDecimal::doubleValue);
    }

    public DoubleArbitrary withDistribution(RandomDistribution distribution) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public DoubleArbitrary between(double min, boolean minIncluded, double max, boolean maxIncluded) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.range = Range.of(this.toBigDecimal(min), minIncluded, this.toBigDecimal(max), maxIncluded);
        return clone;
    }

    public DoubleArbitrary greaterOrEqual(double min) {
        return this.between(min, true, ((BigDecimal)this.generatingArbitrary.range.max).doubleValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public DoubleArbitrary greaterThan(double min) {
        return this.between(min, false, ((BigDecimal)this.generatingArbitrary.range.max).doubleValue(), this.generatingArbitrary.range.maxIncluded);
    }

    public DoubleArbitrary lessOrEqual(double max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).doubleValue(), this.generatingArbitrary.range.minIncluded, max, true);
    }

    public DoubleArbitrary lessThan(double max) {
        return this.between(((BigDecimal)this.generatingArbitrary.range.min).doubleValue(), this.generatingArbitrary.range.minIncluded, max, false);
    }

    public DoubleArbitrary ofScale(int scale) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public DoubleArbitrary shrinkTowards(double target) {
        DefaultDoubleArbitrary clone = (DefaultDoubleArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigDecimal.valueOf(target);
        return clone;
    }

    private BigDecimal toBigDecimal(double value) {
        return new BigDecimal(Double.toString(value));
    }
}

