/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.EmailArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.engine.ArbitraryDecorator;

public class DefaultEmailArbitrary
extends ArbitraryDecorator<String>
implements EmailArbitrary {
    private boolean allowQuotedLocalPart = false;
    private boolean allowUnquotedLocalPart = false;
    private boolean allowDomainHost = false;
    private boolean allowIPv4Host = false;
    private boolean allowIPv6Host = false;

    @Override
    protected Arbitrary<String> arbitrary() {
        Arbitrary<String> arbitraryLocalPart = this.localPart();
        Arbitrary<String> arbitraryDomain = this.host();
        return Combinators.combine(arbitraryLocalPart, arbitraryDomain).as((localPart, domain) -> localPart + "@" + domain);
    }

    private Arbitrary<String> localPart() {
        if (!this.allowUnquotedLocalPart && !this.allowQuotedLocalPart) {
            this.allowUnquotedLocalPart = true;
            this.allowQuotedLocalPart = true;
        }
        Arbitrary<String> unquoted = this.localPartUnquoted();
        Arbitrary<String> quoted = this.localPartQuoted();
        int frequencyUnquoted = this.allowUnquotedLocalPart ? 4 : 0;
        int frequencyQuoted = this.allowQuotedLocalPart ? 1 : 0;
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyUnquoted, unquoted), Tuple.of((Object)frequencyQuoted, quoted)});
    }

    private Arbitrary<String> localPartUnquoted() {
        StringArbitrary unquoted = Arbitraries.strings().alpha().numeric().withChars((CharSequence)"!#$%&'*+-/=?^_`{|}~.").ofMinLength(1).ofMaxLength(64);
        unquoted = unquoted.filter(v -> !v.contains(".."));
        unquoted = unquoted.filter(v -> v.charAt(0) != '.');
        unquoted = unquoted.filter(v -> v.charAt(v.length() - 1) != '.');
        return unquoted.edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"A", "a", "0", "!"}));
    }

    private Arbitrary<String> localPartQuoted() {
        StringArbitrary quoted = Arbitraries.strings().alpha().numeric().withChars((CharSequence)" !#$%&'*+-/=?^_`{|}~.\"(),:;<>@[\\]").ofMinLength(1).ofMaxLength(62);
        quoted = quoted.map(v -> "\"" + v.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
        quoted = quoted.filter(v -> v.length() <= 64);
        return quoted.edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"\"A\"", "\"a\"", "\" \""}));
    }

    private Arbitrary<String> host() {
        if (!(this.allowDomainHost || this.allowIPv4Host || this.allowIPv6Host)) {
            this.allowDomainHost = true;
            this.allowIPv4Host = true;
            this.allowIPv6Host = true;
        }
        int frequencyDomain = this.allowDomainHost ? 4 : 0;
        int frequencyIPv4Addresses = this.allowIPv4Host ? 1 : 0;
        int frequencyIPv6Addresses = this.allowIPv6Host ? 1 : 0;
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyDomain, this.webDomain()), Tuple.of((Object)frequencyIPv4Addresses, this.hostIpv4()), Tuple.of((Object)frequencyIPv6Addresses, this.hostIpv6())});
    }

    private Arbitrary<String> hostIpv4() {
        IntegerArbitrary addressPart = Arbitraries.integers().between(0, 255);
        return Combinators.combine((Arbitrary)addressPart, (Arbitrary)addressPart, (Arbitrary)addressPart, (Arbitrary)addressPart).as((a, b, c, d) -> "[" + a + "." + b + "." + c + "." + d + "]").edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"[0.0.0.0]", "[255.255.255.255]"}).add((Object)"[127.0.0.1]"));
    }

    private Arbitrary<String> hostIpv6() {
        ListArbitrary addressParts = this.ipv6Part().list().ofSize(8);
        Arbitrary plainAddress = addressParts.map(parts -> String.join((CharSequence)":", parts));
        return plainAddress.map(this::removeThreeOrMoreColons).filter(DefaultEmailArbitrary::validUseOfColonInIPv6Address).map(plain -> "[" + plain + "]").edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"[::]", "[0:0:0:0:0:0:0:0]", "[ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff]", "[FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF]"}));
    }

    private Arbitrary<String> ipv6Part() {
        IntegerArbitrary ipv6PartNumber = Arbitraries.integers().between(0, 65535);
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)1, (Object)Arbitraries.just((Object)"")), Tuple.of((Object)8, (Object)ipv6PartNumber.map(this::toLowerHex)), Tuple.of((Object)1, (Object)ipv6PartNumber.map(this::toUpperHex))});
    }

    private String toLowerHex(int ipv6Part) {
        return Integer.toHexString(ipv6Part);
    }

    private String toUpperHex(int ipv6Part) {
        return this.toLowerHex(ipv6Part).toUpperCase();
    }

    private String removeThreeOrMoreColons(String address) {
        while (address.contains(":::")) {
            address = address.replace(":::", "::");
        }
        return address;
    }

    public static boolean validUseOfColonInIPv6Address(String ip) {
        if (!DefaultEmailArbitrary.checkColonPlacement(ip)) {
            return false;
        }
        boolean first = true;
        boolean inCheck = false;
        for (int i = 0; i < ip.length() - 1; ++i) {
            boolean ipContainsTwoColonsAtI;
            boolean bl = ipContainsTwoColonsAtI = ip.charAt(i) == ':' && ip.charAt(i + 1) == ':';
            if (ipContainsTwoColonsAtI && first) {
                first = false;
                inCheck = true;
                continue;
            }
            if (ipContainsTwoColonsAtI && !inCheck) {
                return false;
            }
            if (ipContainsTwoColonsAtI) continue;
            inCheck = false;
        }
        return true;
    }

    private static boolean checkColonPlacement(String ip) {
        boolean ipContainsThreeColons = ip.contains(":::");
        boolean startsWithOnlyOneColon = ip.charAt(0) == ':' && ip.charAt(1) != ':';
        boolean endsWithOnlyOneColon = ip.charAt(ip.length() - 1) == ':' && ip.charAt(ip.length() - 2) != ':';
        return !ipContainsThreeColons && !startsWithOnlyOneColon && !endsWithOnlyOneColon;
    }

    private Arbitrary<String> webDomain() {
        Arbitrary numberOfSubdomains = Arbitraries.integers().between(1, 25).edgeCases(integerConfig -> integerConfig.includeOnly((Object[])new Integer[]{1, 25}));
        Arbitrary<String> topLevelDomain = this.topLevelDomain();
        return numberOfSubdomains.flatMap(depth -> Arbitraries.recursive(() -> topLevelDomain, this::prependDomainPart, (int)depth).filter(v -> v.length() <= 253));
    }

    private Arbitrary<String> prependDomainPart(Arbitrary<String> tail) {
        Arbitrary<String> domainPart = this.domainPart(1, 63);
        return Combinators.combine(domainPart, tail).as((part, rest) -> {
            String newDomain = part + "." + rest;
            if (newDomain.length() > 253) {
                return rest;
            }
            return newDomain;
        });
    }

    private Arbitrary<String> topLevelDomain() {
        return this.domainPart(2, 10).filter(this::notAllNumeric);
    }

    private boolean notAllNumeric(String tld) {
        for (char c : tld.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }

    private Arbitrary<String> domainPart(int minLength, int maxLength) {
        return Arbitraries.strings().withChars((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-").ofMinLength(minLength).ofMaxLength(maxLength).filter(this::validUseOfHyphensInDomainPart);
    }

    private boolean validUseOfHyphensInDomainPart(String domainPart) {
        boolean firstSignNotAHyphen = domainPart.charAt(0) != '-';
        boolean lastSignNotAHyphen = domainPart.charAt(domainPart.length() - 1) != '-';
        return firstSignNotAHyphen && lastSignNotAHyphen;
    }

    public EmailArbitrary quotedLocalPart() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowQuotedLocalPart = true;
        return clone;
    }

    public EmailArbitrary unquotedLocalPart() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowUnquotedLocalPart = true;
        return clone;
    }

    public EmailArbitrary ipv4Host() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowIPv4Host = true;
        return clone;
    }

    public EmailArbitrary ipv6Host() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowIPv6Host = true;
        return clone;
    }

    public EmailArbitrary domainHost() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowDomainHost = true;
        return clone;
    }
}

