/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultIteratorArbitrary<T>
extends MultivalueArbitraryBase<T, Iterator<T>>
implements IteratorArbitrary<T> {
    public DefaultIteratorArbitrary(Arbitrary<T> elementArbitrary, boolean elementsUnique) {
        super(elementArbitrary, elementsUnique);
    }

    @Override
    protected Iterable<T> toIterable(Iterator<T> streamable) {
        return () -> streamable;
    }

    public RandomGenerator<Iterator<T>> generator(int genSize) {
        return this.createListGenerator(genSize).map(List::iterator);
    }

    public Optional<ExhaustiveGenerator<Iterator<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples).map(generator -> generator.map(List::iterator));
    }

    public EdgeCases<Iterator<T>> edgeCases() {
        return EdgeCasesSupport.map(this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize)), List::iterator);
    }

    public IteratorArbitrary<T> ofMaxSize(int maxSize) {
        return (IteratorArbitrary)super.ofMaxSize(maxSize);
    }

    public IteratorArbitrary<T> ofMinSize(int minSize) {
        return (IteratorArbitrary)super.ofMinSize(minSize);
    }
}

