/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.MapArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;

public class DefaultMapArbitrary<K, V>
extends AbstractArbitraryBase
implements MapArbitrary<K, V> {
    private final Arbitrary<K> keysArbitrary;
    private final Arbitrary<V> valuesArbitrary;
    private int minSize = 0;
    private int maxSize = 255;

    public DefaultMapArbitrary(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        this.keysArbitrary = keysArbitrary;
        this.valuesArbitrary = valuesArbitrary;
    }

    public MapArbitrary<K, V> ofMinSize(int minSize) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.minSize = minSize;
        return clone;
    }

    public MapArbitrary<K, V> ofMaxSize(int maxSize) {
        DefaultMapArbitrary clone = (DefaultMapArbitrary)this.typedClone();
        clone.maxSize = maxSize;
        return clone;
    }

    public RandomGenerator<Map<K, V>> generator(int genSize) {
        return this.mapArbitrary().generator(genSize);
    }

    private Arbitrary<Map<K, V>> mapArbitrary() {
        Arbitrary keySets = this.keysArbitrary.set().ofMinSize(this.minSize).ofMaxSize(this.maxSize).map(ArrayList::new);
        return keySets.flatMap(keys -> this.valuesArbitrary.list().ofSize(keys.size()).map(values -> {
            HashMap map = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                Object value = values.get(i);
                map.put(key, value);
            }
            return map;
        }));
    }

    public Optional<ExhaustiveGenerator<Map<K, V>>> exhaustive(long maxNumberOfSamples) {
        return this.mapArbitrary().exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<Map<K, V>> edgeCases() {
        EdgeCases emptyMapEdgeCase = this.minSize == 0 ? EdgeCases.fromSupplier(() -> Shrinkable.unshrinkable(new HashMap())) : EdgeCases.none();
        EdgeCases<Map<K, V>> singleEntryEdgeCases = this.minSize <= 1 ? this.singleEntryEdgeCases() : EdgeCases.none();
        return EdgeCasesSupport.concat(emptyMapEdgeCase, singleEntryEdgeCases);
    }

    private EdgeCases<Map<K, V>> singleEntryEdgeCases() {
        return EdgeCasesSupport.flatMapArbitrary(this.keysArbitrary.edgeCases(), key -> this.valuesArbitrary.map(value -> {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(key, value);
            return map;
        }));
    }
}

