/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.ReportableStream;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultStreamArbitrary<T>
extends MultivalueArbitraryBase<T, Stream<T>>
implements StreamArbitrary<T> {
    public DefaultStreamArbitrary(Arbitrary<T> elementArbitrary, boolean elementsUnique) {
        super(elementArbitrary, elementsUnique);
    }

    @Override
    protected Iterable<T> toIterable(Stream<T> streamable) {
        return streamable::iterator;
    }

    public RandomGenerator<Stream<T>> generator(int genSize) {
        return this.createListGenerator(genSize).map(ReportableStream::new);
    }

    public Optional<ExhaustiveGenerator<Stream<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples).map(generator -> generator.map(ReportableStream::new));
    }

    public EdgeCases<Stream<T>> edgeCases() {
        return EdgeCasesSupport.map(this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize)), Collection::stream);
    }

    public StreamArbitrary<T> ofMaxSize(int maxSize) {
        return (StreamArbitrary)super.ofMaxSize(maxSize);
    }

    public StreamArbitrary<T> ofMinSize(int minSize) {
        return (StreamArbitrary)super.ofMinSize(minSize);
    }
}

